package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CustomLogSourceConfiguration(
    crawlerConfiguration: zio.aws.securitylake.model.CustomLogSourceCrawlerConfiguration,
    providerIdentity: zio.aws.securitylake.model.AwsIdentity
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CustomLogSourceConfiguration = {
    import CustomLogSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CustomLogSourceConfiguration
      .builder()
      .crawlerConfiguration(crawlerConfiguration.buildAwsValue())
      .providerIdentity(providerIdentity.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CustomLogSourceConfiguration.ReadOnly =
    zio.aws.securitylake.model.CustomLogSourceConfiguration
      .wrap(buildAwsValue())
}
object CustomLogSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CustomLogSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CustomLogSourceConfiguration =
      zio.aws.securitylake.model.CustomLogSourceConfiguration(
        crawlerConfiguration.asEditable,
        providerIdentity.asEditable
      )
    def crawlerConfiguration
        : zio.aws.securitylake.model.CustomLogSourceCrawlerConfiguration.ReadOnly
    def providerIdentity: zio.aws.securitylake.model.AwsIdentity.ReadOnly
    def getCrawlerConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.securitylake.model.CustomLogSourceCrawlerConfiguration.ReadOnly
    ] = ZIO.succeed(crawlerConfiguration)
    def getProviderIdentity
        : ZIO[Any, Nothing, zio.aws.securitylake.model.AwsIdentity.ReadOnly] =
      ZIO.succeed(providerIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CustomLogSourceConfiguration
  ) extends zio.aws.securitylake.model.CustomLogSourceConfiguration.ReadOnly {
    override val crawlerConfiguration
        : zio.aws.securitylake.model.CustomLogSourceCrawlerConfiguration.ReadOnly =
      zio.aws.securitylake.model.CustomLogSourceCrawlerConfiguration
        .wrap(impl.crawlerConfiguration())
    override val providerIdentity
        : zio.aws.securitylake.model.AwsIdentity.ReadOnly =
      zio.aws.securitylake.model.AwsIdentity.wrap(impl.providerIdentity())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CustomLogSourceConfiguration
  ): zio.aws.securitylake.model.CustomLogSourceConfiguration.ReadOnly =
    new Wrapper(impl)
}
