package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.RoleArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CustomLogSourceCrawlerConfiguration(roleArn: RoleArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CustomLogSourceCrawlerConfiguration = {
    import CustomLogSourceCrawlerConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CustomLogSourceCrawlerConfiguration
      .builder()
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.CustomLogSourceCrawlerConfiguration.ReadOnly =
    zio.aws.securitylake.model.CustomLogSourceCrawlerConfiguration
      .wrap(buildAwsValue())
}
object CustomLogSourceCrawlerConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CustomLogSourceCrawlerConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.CustomLogSourceCrawlerConfiguration =
      zio.aws.securitylake.model.CustomLogSourceCrawlerConfiguration(roleArn)
    def roleArn: RoleArn
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CustomLogSourceCrawlerConfiguration
  ) extends zio.aws.securitylake.model.CustomLogSourceCrawlerConfiguration.ReadOnly {
    override val roleArn: RoleArn =
      zio.aws.securitylake.model.primitives.RoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CustomLogSourceCrawlerConfiguration
  ): zio.aws.securitylake.model.CustomLogSourceCrawlerConfiguration.ReadOnly =
    new Wrapper(impl)
}
