package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{RoleArn, S3URI}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomLogSourceProvider(
    location: Optional[S3URI] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CustomLogSourceProvider = {
    import CustomLogSourceProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CustomLogSourceProvider
      .builder()
      .optionallyWith(
        location.map(value => S3URI.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.CustomLogSourceProvider.ReadOnly =
    zio.aws.securitylake.model.CustomLogSourceProvider.wrap(buildAwsValue())
}
object CustomLogSourceProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CustomLogSourceProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CustomLogSourceProvider =
      zio.aws.securitylake.model.CustomLogSourceProvider(
        location.map(value => value),
        roleArn.map(value => value)
      )
    def location: Optional[S3URI]
    def roleArn: Optional[RoleArn]
    def getLocation: ZIO[Any, AwsError, S3URI] =
      AwsError.unwrapOptionField("location", location)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CustomLogSourceProvider
  ) extends zio.aws.securitylake.model.CustomLogSourceProvider.ReadOnly {
    override val location: Optional[S3URI] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => zio.aws.securitylake.model.primitives.S3URI(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.securitylake.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CustomLogSourceProvider
  ): zio.aws.securitylake.model.CustomLogSourceProvider.ReadOnly = new Wrapper(
    impl
  )
}
