package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  CustomLogSourceVersion,
  CustomLogSourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomLogSourceResource(
    attributes: Optional[zio.aws.securitylake.model.CustomLogSourceAttributes] =
      Optional.Absent,
    provider: Optional[zio.aws.securitylake.model.CustomLogSourceProvider] =
      Optional.Absent,
    sourceName: Optional[CustomLogSourceName] = Optional.Absent,
    sourceVersion: Optional[CustomLogSourceVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.CustomLogSourceResource = {
    import CustomLogSourceResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.CustomLogSourceResource
      .builder()
      .optionallyWith(attributes.map(value => value.buildAwsValue()))(
        _.attributes
      )
      .optionallyWith(provider.map(value => value.buildAwsValue()))(_.provider)
      .optionallyWith(
        sourceName.map(value =>
          CustomLogSourceName.unwrap(value): java.lang.String
        )
      )(_.sourceName)
      .optionallyWith(
        sourceVersion.map(value =>
          CustomLogSourceVersion.unwrap(value): java.lang.String
        )
      )(_.sourceVersion)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.CustomLogSourceResource.ReadOnly =
    zio.aws.securitylake.model.CustomLogSourceResource.wrap(buildAwsValue())
}
object CustomLogSourceResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.CustomLogSourceResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.CustomLogSourceResource =
      zio.aws.securitylake.model.CustomLogSourceResource(
        attributes.map(value => value.asEditable),
        provider.map(value => value.asEditable),
        sourceName.map(value => value),
        sourceVersion.map(value => value)
      )
    def attributes: Optional[
      zio.aws.securitylake.model.CustomLogSourceAttributes.ReadOnly
    ]
    def provider
        : Optional[zio.aws.securitylake.model.CustomLogSourceProvider.ReadOnly]
    def sourceName: Optional[CustomLogSourceName]
    def sourceVersion: Optional[CustomLogSourceVersion]
    def getAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.CustomLogSourceAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("attributes", attributes)
    def getProvider: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.CustomLogSourceProvider.ReadOnly
    ] = AwsError.unwrapOptionField("provider", provider)
    def getSourceName: ZIO[Any, AwsError, CustomLogSourceName] =
      AwsError.unwrapOptionField("sourceName", sourceName)
    def getSourceVersion: ZIO[Any, AwsError, CustomLogSourceVersion] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.CustomLogSourceResource
  ) extends zio.aws.securitylake.model.CustomLogSourceResource.ReadOnly {
    override val attributes: Optional[
      zio.aws.securitylake.model.CustomLogSourceAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        zio.aws.securitylake.model.CustomLogSourceAttributes.wrap(value)
      )
    override val provider: Optional[
      zio.aws.securitylake.model.CustomLogSourceProvider.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provider())
      .map(value =>
        zio.aws.securitylake.model.CustomLogSourceProvider.wrap(value)
      )
    override val sourceName: Optional[CustomLogSourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceName())
        .map(value =>
          zio.aws.securitylake.model.primitives.CustomLogSourceName(value)
        )
    override val sourceVersion: Optional[CustomLogSourceVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceVersion())
        .map(value =>
          zio.aws.securitylake.model.primitives.CustomLogSourceVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.CustomLogSourceResource
  ): zio.aws.securitylake.model.CustomLogSourceResource.ReadOnly = new Wrapper(
    impl
  )
}
