package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{RoleArn, Region}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataLakeReplicationConfiguration(
    regions: Optional[Iterable[Region]] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DataLakeReplicationConfiguration = {
    import DataLakeReplicationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DataLakeReplicationConfiguration
      .builder()
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DataLakeReplicationConfiguration.ReadOnly =
    zio.aws.securitylake.model.DataLakeReplicationConfiguration
      .wrap(buildAwsValue())
}
object DataLakeReplicationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DataLakeReplicationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.DataLakeReplicationConfiguration =
      zio.aws.securitylake.model.DataLakeReplicationConfiguration(
        regions.map(value => value),
        roleArn.map(value => value)
      )
    def regions: Optional[List[Region]]
    def roleArn: Optional[RoleArn]
    def getRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("regions", regions)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeReplicationConfiguration
  ) extends zio.aws.securitylake.model.DataLakeReplicationConfiguration.ReadOnly {
    override val regions: Optional[List[Region]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.primitives.Region(item)
        }.toList
      )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.securitylake.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeReplicationConfiguration
  ): zio.aws.securitylake.model.DataLakeReplicationConfiguration.ReadOnly =
    new Wrapper(impl)
}
