package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait DataLakeStatus {
  def unwrap: software.amazon.awssdk.services.securitylake.model.DataLakeStatus
}
object DataLakeStatus {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.DataLakeStatus
  ): zio.aws.securitylake.model.DataLakeStatus = value match {
    case software.amazon.awssdk.services.securitylake.model.DataLakeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.DataLakeStatus.INITIALIZED =>
      val r = INITIALIZED
      r
    case software.amazon.awssdk.services.securitylake.model.DataLakeStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.securitylake.model.DataLakeStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.securitylake.model.DataLakeStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.DataLakeStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.DataLakeStatus =
      software.amazon.awssdk.services.securitylake.model.DataLakeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIALIZED extends zio.aws.securitylake.model.DataLakeStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.DataLakeStatus =
      software.amazon.awssdk.services.securitylake.model.DataLakeStatus.INITIALIZED
  }
  case object PENDING extends zio.aws.securitylake.model.DataLakeStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.DataLakeStatus =
      software.amazon.awssdk.services.securitylake.model.DataLakeStatus.PENDING
  }
  case object COMPLETED extends zio.aws.securitylake.model.DataLakeStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.DataLakeStatus =
      software.amazon.awssdk.services.securitylake.model.DataLakeStatus.COMPLETED
  }
  case object FAILED extends zio.aws.securitylake.model.DataLakeStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.DataLakeStatus =
      software.amazon.awssdk.services.securitylake.model.DataLakeStatus.FAILED
  }
}
