package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataLakeUpdateException(
    code: Optional[String] = Optional.Absent,
    reason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DataLakeUpdateException = {
    import DataLakeUpdateException.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DataLakeUpdateException
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.DataLakeUpdateException.ReadOnly =
    zio.aws.securitylake.model.DataLakeUpdateException.wrap(buildAwsValue())
}
object DataLakeUpdateException {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DataLakeUpdateException
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DataLakeUpdateException =
      zio.aws.securitylake.model.DataLakeUpdateException(
        code.map(value => value),
        reason.map(value => value)
      )
    def code: Optional[String]
    def reason: Optional[String]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeUpdateException
  ) extends zio.aws.securitylake.model.DataLakeUpdateException.ReadOnly {
    override val code: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: String)
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeUpdateException
  ): zio.aws.securitylake.model.DataLakeUpdateException.ReadOnly = new Wrapper(
    impl
  )
}
