package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataLakeUpdateStatus(
    exception: Optional[zio.aws.securitylake.model.DataLakeUpdateException] =
      Optional.Absent,
    requestId: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.securitylake.model.DataLakeStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DataLakeUpdateStatus = {
    import DataLakeUpdateStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DataLakeUpdateStatus
      .builder()
      .optionallyWith(exception.map(value => value.buildAwsValue()))(
        _.exception
      )
      .optionallyWith(requestId.map(value => value: java.lang.String))(
        _.requestId
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.DataLakeUpdateStatus.ReadOnly =
    zio.aws.securitylake.model.DataLakeUpdateStatus.wrap(buildAwsValue())
}
object DataLakeUpdateStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DataLakeUpdateStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DataLakeUpdateStatus =
      zio.aws.securitylake.model.DataLakeUpdateStatus(
        exception.map(value => value.asEditable),
        requestId.map(value => value),
        status.map(value => value)
      )
    def exception
        : Optional[zio.aws.securitylake.model.DataLakeUpdateException.ReadOnly]
    def requestId: Optional[String]
    def status: Optional[zio.aws.securitylake.model.DataLakeStatus]
    def getException: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.DataLakeUpdateException.ReadOnly
    ] = AwsError.unwrapOptionField("exception", exception)
    def getRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.securitylake.model.DataLakeStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeUpdateStatus
  ) extends zio.aws.securitylake.model.DataLakeUpdateStatus.ReadOnly {
    override val exception: Optional[
      zio.aws.securitylake.model.DataLakeUpdateException.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exception())
      .map(value =>
        zio.aws.securitylake.model.DataLakeUpdateException.wrap(value)
      )
    override val requestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => value: String)
    override val status: Optional[zio.aws.securitylake.model.DataLakeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.securitylake.model.DataLakeStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DataLakeUpdateStatus
  ): zio.aws.securitylake.model.DataLakeUpdateStatus.ReadOnly = new Wrapper(
    impl
  )
}
