package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAwsLogSourceRequest(
    sources: Iterable[zio.aws.securitylake.model.AwsLogSourceConfiguration]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest = {
    import DeleteAwsLogSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest
      .builder()
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DeleteAwsLogSourceRequest.ReadOnly =
    zio.aws.securitylake.model.DeleteAwsLogSourceRequest.wrap(buildAwsValue())
}
object DeleteAwsLogSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DeleteAwsLogSourceRequest =
      zio.aws.securitylake.model.DeleteAwsLogSourceRequest(sources.map { item =>
        item.asEditable
      })
    def sources
        : List[zio.aws.securitylake.model.AwsLogSourceConfiguration.ReadOnly]
    def getSources: ZIO[Any, Nothing, List[
      zio.aws.securitylake.model.AwsLogSourceConfiguration.ReadOnly
    ]] = ZIO.succeed(sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest
  ) extends zio.aws.securitylake.model.DeleteAwsLogSourceRequest.ReadOnly {
    override val sources
        : List[zio.aws.securitylake.model.AwsLogSourceConfiguration.ReadOnly] =
      impl
        .sources()
        .asScala
        .map { item =>
          zio.aws.securitylake.model.AwsLogSourceConfiguration.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest
  ): zio.aws.securitylake.model.DeleteAwsLogSourceRequest.ReadOnly =
    new Wrapper(impl)
}
