package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  CustomLogSourceVersion,
  CustomLogSourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteCustomLogSourceRequest(
    sourceName: CustomLogSourceName,
    sourceVersion: Optional[CustomLogSourceVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest = {
    import DeleteCustomLogSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest
      .builder()
      .sourceName(CustomLogSourceName.unwrap(sourceName): java.lang.String)
      .optionallyWith(
        sourceVersion.map(value =>
          CustomLogSourceVersion.unwrap(value): java.lang.String
        )
      )(_.sourceVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.DeleteCustomLogSourceRequest.ReadOnly =
    zio.aws.securitylake.model.DeleteCustomLogSourceRequest
      .wrap(buildAwsValue())
}
object DeleteCustomLogSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.DeleteCustomLogSourceRequest =
      zio.aws.securitylake.model.DeleteCustomLogSourceRequest(
        sourceName,
        sourceVersion.map(value => value)
      )
    def sourceName: CustomLogSourceName
    def sourceVersion: Optional[CustomLogSourceVersion]
    def getSourceName: ZIO[Any, Nothing, CustomLogSourceName] =
      ZIO.succeed(sourceName)
    def getSourceVersion: ZIO[Any, AwsError, CustomLogSourceVersion] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest
  ) extends zio.aws.securitylake.model.DeleteCustomLogSourceRequest.ReadOnly {
    override val sourceName: CustomLogSourceName =
      zio.aws.securitylake.model.primitives
        .CustomLogSourceName(impl.sourceName())
    override val sourceVersion: Optional[CustomLogSourceVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceVersion())
        .map(value =>
          zio.aws.securitylake.model.primitives.CustomLogSourceVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest
  ): zio.aws.securitylake.model.DeleteCustomLogSourceRequest.ReadOnly =
    new Wrapper(impl)
}
