package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDataLakeOrganizationConfigurationResponse(
    autoEnableNewAccount: Optional[Iterable[
      zio.aws.securitylake.model.DataLakeAutoEnableNewAccountConfiguration
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.GetDataLakeOrganizationConfigurationResponse = {
    import GetDataLakeOrganizationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.GetDataLakeOrganizationConfigurationResponse
      .builder()
      .optionallyWith(
        autoEnableNewAccount.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.autoEnableNewAccount)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.GetDataLakeOrganizationConfigurationResponse.ReadOnly =
    zio.aws.securitylake.model.GetDataLakeOrganizationConfigurationResponse
      .wrap(buildAwsValue())
}
object GetDataLakeOrganizationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.GetDataLakeOrganizationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securitylake.model.GetDataLakeOrganizationConfigurationResponse =
      zio.aws.securitylake.model.GetDataLakeOrganizationConfigurationResponse(
        autoEnableNewAccount.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def autoEnableNewAccount: Optional[List[
      zio.aws.securitylake.model.DataLakeAutoEnableNewAccountConfiguration.ReadOnly
    ]]
    def getAutoEnableNewAccount: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.DataLakeAutoEnableNewAccountConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("autoEnableNewAccount", autoEnableNewAccount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.GetDataLakeOrganizationConfigurationResponse
  ) extends zio.aws.securitylake.model.GetDataLakeOrganizationConfigurationResponse.ReadOnly {
    override val autoEnableNewAccount: Optional[List[
      zio.aws.securitylake.model.DataLakeAutoEnableNewAccountConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.autoEnableNewAccount())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.DataLakeAutoEnableNewAccountConfiguration
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.GetDataLakeOrganizationConfigurationResponse
  ): zio.aws.securitylake.model.GetDataLakeOrganizationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
