package zio.aws.securitylake.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.securitylake.model.primitives.{
  NextToken,
  MaxResults,
  AwsAccountId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetDataLakeSourcesRequest(
    accounts: Optional[Iterable[AwsAccountId]] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesRequest = {
    import GetDataLakeSourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesRequest
      .builder()
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            AwsAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.GetDataLakeSourcesRequest.ReadOnly =
    zio.aws.securitylake.model.GetDataLakeSourcesRequest.wrap(buildAwsValue())
}
object GetDataLakeSourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.GetDataLakeSourcesRequest =
      zio.aws.securitylake.model.GetDataLakeSourcesRequest(
        accounts.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def accounts: Optional[List[AwsAccountId]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getAccounts: ZIO[Any, AwsError, List[AwsAccountId]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesRequest
  ) extends zio.aws.securitylake.model.GetDataLakeSourcesRequest.ReadOnly {
    override val accounts: Optional[List[AwsAccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.primitives.AwsAccountId(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.securitylake.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securitylake.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesRequest
  ): zio.aws.securitylake.model.GetDataLakeSourcesRequest.ReadOnly =
    new Wrapper(impl)
}
