package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.UUID
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSubscriberRequest(subscriberId: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.GetSubscriberRequest = {
    import GetSubscriberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.GetSubscriberRequest
      .builder()
      .subscriberId(UUID.unwrap(subscriberId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.GetSubscriberRequest.ReadOnly =
    zio.aws.securitylake.model.GetSubscriberRequest.wrap(buildAwsValue())
}
object GetSubscriberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.GetSubscriberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.GetSubscriberRequest =
      zio.aws.securitylake.model.GetSubscriberRequest(subscriberId)
    def subscriberId: UUID
    def getSubscriberId: ZIO[Any, Nothing, UUID] = ZIO.succeed(subscriberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.GetSubscriberRequest
  ) extends zio.aws.securitylake.model.GetSubscriberRequest.ReadOnly {
    override val subscriberId: UUID =
      zio.aws.securitylake.model.primitives.UUID(impl.subscriberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.GetSubscriberRequest
  ): zio.aws.securitylake.model.GetSubscriberRequest.ReadOnly = new Wrapper(
    impl
  )
}
