package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait HttpMethod {
  def unwrap: software.amazon.awssdk.services.securitylake.model.HttpMethod
}
object HttpMethod {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.HttpMethod
  ): zio.aws.securitylake.model.HttpMethod = value match {
    case software.amazon.awssdk.services.securitylake.model.HttpMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.HttpMethod.POST =>
      val r = POST
      r
    case software.amazon.awssdk.services.securitylake.model.HttpMethod.PUT =>
      val r = PUT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.HttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.HttpMethod =
      software.amazon.awssdk.services.securitylake.model.HttpMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object POST extends zio.aws.securitylake.model.HttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.HttpMethod =
      software.amazon.awssdk.services.securitylake.model.HttpMethod.POST
  }
  case object PUT extends zio.aws.securitylake.model.HttpMethod {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.HttpMethod =
      software.amazon.awssdk.services.securitylake.model.HttpMethod.PUT
  }
}
