package zio.aws.securitylake.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.securitylake.model.primitives.{
  Region,
  NextToken,
  MaxResults,
  AwsAccountId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListLogSourcesRequest(
    accounts: Optional[Iterable[AwsAccountId]] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    regions: Optional[Iterable[Region]] = Optional.Absent,
    sources: Optional[Iterable[zio.aws.securitylake.model.LogSourceResource]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest = {
    import ListLogSourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest
      .builder()
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            AwsAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.ListLogSourcesRequest.ReadOnly =
    zio.aws.securitylake.model.ListLogSourcesRequest.wrap(buildAwsValue())
}
object ListLogSourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.ListLogSourcesRequest =
      zio.aws.securitylake.model.ListLogSourcesRequest(
        accounts.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        regions.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accounts: Optional[List[AwsAccountId]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def regions: Optional[List[Region]]
    def sources
        : Optional[List[zio.aws.securitylake.model.LogSourceResource.ReadOnly]]
    def getAccounts: ZIO[Any, AwsError, List[AwsAccountId]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("regions", regions)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.LogSourceResource.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest
  ) extends zio.aws.securitylake.model.ListLogSourcesRequest.ReadOnly {
    override val accounts: Optional[List[AwsAccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.primitives.AwsAccountId(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.securitylake.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securitylake.model.primitives.NextToken(value))
    override val regions: Optional[List[Region]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.primitives.Region(item)
        }.toList
      )
    override val sources: Optional[
      List[zio.aws.securitylake.model.LogSourceResource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.LogSourceResource.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest
  ): zio.aws.securitylake.model.ListLogSourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
