package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLogSourcesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    sources: Optional[Iterable[zio.aws.securitylake.model.LogSource]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse = {
    import ListLogSourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly =
    zio.aws.securitylake.model.ListLogSourcesResponse.wrap(buildAwsValue())
}
object ListLogSourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.ListLogSourcesResponse =
      zio.aws.securitylake.model.ListLogSourcesResponse(
        nextToken.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def sources: Optional[List[zio.aws.securitylake.model.LogSource.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.LogSource.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse
  ) extends zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securitylake.model.primitives.NextToken(value))
    override val sources
        : Optional[List[zio.aws.securitylake.model.LogSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.LogSource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse
  ): zio.aws.securitylake.model.ListLogSourcesResponse.ReadOnly = new Wrapper(
    impl
  )
}
