package zio.aws.securitylake.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.securitylake.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSubscribersRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest = {
    import ListSubscribersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.ListSubscribersRequest.ReadOnly =
    zio.aws.securitylake.model.ListSubscribersRequest.wrap(buildAwsValue())
}
object ListSubscribersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.ListSubscribersRequest =
      zio.aws.securitylake.model.ListSubscribersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest
  ) extends zio.aws.securitylake.model.ListSubscribersRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.securitylake.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.securitylake.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest
  ): zio.aws.securitylake.model.ListSubscribersRequest.ReadOnly = new Wrapper(
    impl
  )
}
