package zio.aws.securitylake.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NotificationConfiguration(
    httpsNotificationConfiguration: Optional[
      zio.aws.securitylake.model.HttpsNotificationConfiguration
    ] = Optional.Absent,
    sqsNotificationConfiguration: Optional[
      zio.aws.securitylake.model.SqsNotificationConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.NotificationConfiguration = {
    import NotificationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.NotificationConfiguration
      .builder()
      .optionallyWith(
        httpsNotificationConfiguration.map(value => value.buildAwsValue())
      )(_.httpsNotificationConfiguration)
      .optionallyWith(
        sqsNotificationConfiguration.map(value => value.buildAwsValue())
      )(_.sqsNotificationConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.securitylake.model.NotificationConfiguration.ReadOnly =
    zio.aws.securitylake.model.NotificationConfiguration.wrap(buildAwsValue())
}
object NotificationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.NotificationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.NotificationConfiguration =
      zio.aws.securitylake.model.NotificationConfiguration(
        httpsNotificationConfiguration.map(value => value.asEditable),
        sqsNotificationConfiguration.map(value => value.asEditable)
      )
    def httpsNotificationConfiguration: Optional[
      zio.aws.securitylake.model.HttpsNotificationConfiguration.ReadOnly
    ]
    def sqsNotificationConfiguration: Optional[
      zio.aws.securitylake.model.SqsNotificationConfiguration.ReadOnly
    ]
    def getHttpsNotificationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.HttpsNotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "httpsNotificationConfiguration",
      httpsNotificationConfiguration
    )
    def getSqsNotificationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securitylake.model.SqsNotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sqsNotificationConfiguration",
      sqsNotificationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.NotificationConfiguration
  ) extends zio.aws.securitylake.model.NotificationConfiguration.ReadOnly {
    override val httpsNotificationConfiguration: Optional[
      zio.aws.securitylake.model.HttpsNotificationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.httpsNotificationConfiguration())
      .map(value =>
        zio.aws.securitylake.model.HttpsNotificationConfiguration.wrap(value)
      )
    override val sqsNotificationConfiguration: Optional[
      zio.aws.securitylake.model.SqsNotificationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sqsNotificationConfiguration())
      .map(value =>
        zio.aws.securitylake.model.SqsNotificationConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.NotificationConfiguration
  ): zio.aws.securitylake.model.NotificationConfiguration.ReadOnly =
    new Wrapper(impl)
}
