package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait SourceCollectionStatus {
  def unwrap: software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus
}
object SourceCollectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus
  ): zio.aws.securitylake.model.SourceCollectionStatus = value match {
    case software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus.COLLECTING =>
      val r = COLLECTING
      r
    case software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus.MISCONFIGURED =>
      val r = MISCONFIGURED
      r
    case software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus.NOT_COLLECTING =>
      val r = NOT_COLLECTING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.SourceCollectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus =
      software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COLLECTING
      extends zio.aws.securitylake.model.SourceCollectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus =
      software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus.COLLECTING
  }
  case object MISCONFIGURED
      extends zio.aws.securitylake.model.SourceCollectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus =
      software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus.MISCONFIGURED
  }
  case object NOT_COLLECTING
      extends zio.aws.securitylake.model.SourceCollectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus =
      software.amazon.awssdk.services.securitylake.model.SourceCollectionStatus.NOT_COLLECTING
  }
}
