package zio.aws.securitylake.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.securitylake.model.primitives.{
  RoleArn,
  SafeString,
  ResourceShareName,
  S3BucketArn,
  SyntheticTimestamp_date_time,
  AmazonResourceName,
  UUID,
  ResourceShareArn
}
import scala.jdk.CollectionConverters.*
final case class SubscriberResource(
    accessTypes: Optional[Iterable[zio.aws.securitylake.model.AccessType]] =
      Optional.Absent,
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    resourceShareArn: Optional[ResourceShareArn] = Optional.Absent,
    resourceShareName: Optional[ResourceShareName] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    s3BucketArn: Optional[S3BucketArn] = Optional.Absent,
    sources: Iterable[zio.aws.securitylake.model.LogSourceResource],
    subscriberArn: AmazonResourceName,
    subscriberDescription: Optional[SafeString] = Optional.Absent,
    subscriberEndpoint: Optional[SafeString] = Optional.Absent,
    subscriberId: UUID,
    subscriberIdentity: zio.aws.securitylake.model.AwsIdentity,
    subscriberName: SafeString,
    subscriberStatus: Optional[zio.aws.securitylake.model.SubscriberStatus] =
      Optional.Absent,
    updatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.SubscriberResource = {
    import SubscriberResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.SubscriberResource
      .builder()
      .optionallyWith(
        accessTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.accessTypesWithStrings)
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .optionallyWith(
        resourceShareArn.map(value =>
          ResourceShareArn.unwrap(value): java.lang.String
        )
      )(_.resourceShareArn)
      .optionallyWith(
        resourceShareName.map(value =>
          ResourceShareName.unwrap(value): java.lang.String
        )
      )(_.resourceShareName)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        s3BucketArn.map(value => S3BucketArn.unwrap(value): java.lang.String)
      )(_.s3BucketArn)
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .subscriberArn(AmazonResourceName.unwrap(subscriberArn): java.lang.String)
      .optionallyWith(
        subscriberDescription.map(value =>
          SafeString.unwrap(value): java.lang.String
        )
      )(_.subscriberDescription)
      .optionallyWith(
        subscriberEndpoint.map(value =>
          SafeString.unwrap(value): java.lang.String
        )
      )(_.subscriberEndpoint)
      .subscriberId(UUID.unwrap(subscriberId): java.lang.String)
      .subscriberIdentity(subscriberIdentity.buildAwsValue())
      .subscriberName(SafeString.unwrap(subscriberName): java.lang.String)
      .optionallyWith(subscriberStatus.map(value => value.unwrap))(
        _.subscriberStatus
      )
      .optionallyWith(
        updatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.SubscriberResource.ReadOnly =
    zio.aws.securitylake.model.SubscriberResource.wrap(buildAwsValue())
}
object SubscriberResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.SubscriberResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.SubscriberResource =
      zio.aws.securitylake.model.SubscriberResource(
        accessTypes.map(value => value),
        createdAt.map(value => value),
        resourceShareArn.map(value => value),
        resourceShareName.map(value => value),
        roleArn.map(value => value),
        s3BucketArn.map(value => value),
        sources.map { item =>
          item.asEditable
        },
        subscriberArn,
        subscriberDescription.map(value => value),
        subscriberEndpoint.map(value => value),
        subscriberId,
        subscriberIdentity.asEditable,
        subscriberName,
        subscriberStatus.map(value => value),
        updatedAt.map(value => value)
      )
    def accessTypes: Optional[List[zio.aws.securitylake.model.AccessType]]
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def resourceShareArn: Optional[ResourceShareArn]
    def resourceShareName: Optional[ResourceShareName]
    def roleArn: Optional[RoleArn]
    def s3BucketArn: Optional[S3BucketArn]
    def sources: List[zio.aws.securitylake.model.LogSourceResource.ReadOnly]
    def subscriberArn: AmazonResourceName
    def subscriberDescription: Optional[SafeString]
    def subscriberEndpoint: Optional[SafeString]
    def subscriberId: UUID
    def subscriberIdentity: zio.aws.securitylake.model.AwsIdentity.ReadOnly
    def subscriberName: SafeString
    def subscriberStatus: Optional[zio.aws.securitylake.model.SubscriberStatus]
    def updatedAt: Optional[SyntheticTimestamp_date_time]
    def getAccessTypes
        : ZIO[Any, AwsError, List[zio.aws.securitylake.model.AccessType]] =
      AwsError.unwrapOptionField("accessTypes", accessTypes)
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getResourceShareArn: ZIO[Any, AwsError, ResourceShareArn] =
      AwsError.unwrapOptionField("resourceShareArn", resourceShareArn)
    def getResourceShareName: ZIO[Any, AwsError, ResourceShareName] =
      AwsError.unwrapOptionField("resourceShareName", resourceShareName)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getS3BucketArn: ZIO[Any, AwsError, S3BucketArn] =
      AwsError.unwrapOptionField("s3BucketArn", s3BucketArn)
    def getSources: ZIO[Any, Nothing, List[
      zio.aws.securitylake.model.LogSourceResource.ReadOnly
    ]] = ZIO.succeed(sources)
    def getSubscriberArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(subscriberArn)
    def getSubscriberDescription: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("subscriberDescription", subscriberDescription)
    def getSubscriberEndpoint: ZIO[Any, AwsError, SafeString] =
      AwsError.unwrapOptionField("subscriberEndpoint", subscriberEndpoint)
    def getSubscriberId: ZIO[Any, Nothing, UUID] = ZIO.succeed(subscriberId)
    def getSubscriberIdentity
        : ZIO[Any, Nothing, zio.aws.securitylake.model.AwsIdentity.ReadOnly] =
      ZIO.succeed(subscriberIdentity)
    def getSubscriberName: ZIO[Any, Nothing, SafeString] =
      ZIO.succeed(subscriberName)
    def getSubscriberStatus
        : ZIO[Any, AwsError, zio.aws.securitylake.model.SubscriberStatus] =
      AwsError.unwrapOptionField("subscriberStatus", subscriberStatus)
    def getUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.SubscriberResource
  ) extends zio.aws.securitylake.model.SubscriberResource.ReadOnly {
    override val accessTypes
        : Optional[List[zio.aws.securitylake.model.AccessType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securitylake.model.AccessType.wrap(item)
          }.toList
        )
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.securitylake.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val resourceShareArn: Optional[ResourceShareArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareArn())
        .map(value =>
          zio.aws.securitylake.model.primitives.ResourceShareArn(value)
        )
    override val resourceShareName: Optional[ResourceShareName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceShareName())
        .map(value =>
          zio.aws.securitylake.model.primitives.ResourceShareName(value)
        )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.securitylake.model.primitives.RoleArn(value))
    override val s3BucketArn: Optional[S3BucketArn] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketArn())
      .map(value => zio.aws.securitylake.model.primitives.S3BucketArn(value))
    override val sources
        : List[zio.aws.securitylake.model.LogSourceResource.ReadOnly] = impl
      .sources()
      .asScala
      .map { item =>
        zio.aws.securitylake.model.LogSourceResource.wrap(item)
      }
      .toList
    override val subscriberArn: AmazonResourceName =
      zio.aws.securitylake.model.primitives
        .AmazonResourceName(impl.subscriberArn())
    override val subscriberDescription: Optional[SafeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriberDescription())
        .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
    override val subscriberEndpoint: Optional[SafeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriberEndpoint())
        .map(value => zio.aws.securitylake.model.primitives.SafeString(value))
    override val subscriberId: UUID =
      zio.aws.securitylake.model.primitives.UUID(impl.subscriberId())
    override val subscriberIdentity
        : zio.aws.securitylake.model.AwsIdentity.ReadOnly =
      zio.aws.securitylake.model.AwsIdentity.wrap(impl.subscriberIdentity())
    override val subscriberName: SafeString =
      zio.aws.securitylake.model.primitives.SafeString(impl.subscriberName())
    override val subscriberStatus
        : Optional[zio.aws.securitylake.model.SubscriberStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriberStatus())
        .map(value => zio.aws.securitylake.model.SubscriberStatus.wrap(value))
    override val updatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedAt())
        .map(value =>
          zio.aws.securitylake.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.SubscriberResource
  ): zio.aws.securitylake.model.SubscriberResource.ReadOnly = new Wrapper(impl)
}
