package zio.aws.securitylake.model
import scala.jdk.CollectionConverters.*
sealed trait SubscriberStatus {
  def unwrap
      : software.amazon.awssdk.services.securitylake.model.SubscriberStatus
}
object SubscriberStatus {
  def wrap(
      value: software.amazon.awssdk.services.securitylake.model.SubscriberStatus
  ): zio.aws.securitylake.model.SubscriberStatus = value match {
    case software.amazon.awssdk.services.securitylake.model.SubscriberStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriberStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriberStatus.DEACTIVATED =>
      val r = DEACTIVATED
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriberStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.securitylake.model.SubscriberStatus.READY =>
      val r = READY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securitylake.model.SubscriberStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriberStatus =
      software.amazon.awssdk.services.securitylake.model.SubscriberStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.securitylake.model.SubscriberStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriberStatus =
      software.amazon.awssdk.services.securitylake.model.SubscriberStatus.ACTIVE
  }
  case object DEACTIVATED extends zio.aws.securitylake.model.SubscriberStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriberStatus =
      software.amazon.awssdk.services.securitylake.model.SubscriberStatus.DEACTIVATED
  }
  case object PENDING extends zio.aws.securitylake.model.SubscriberStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriberStatus =
      software.amazon.awssdk.services.securitylake.model.SubscriberStatus.PENDING
  }
  case object READY extends zio.aws.securitylake.model.SubscriberStatus {
    override def unwrap
        : software.amazon.awssdk.services.securitylake.model.SubscriberStatus =
      software.amazon.awssdk.services.securitylake.model.SubscriberStatus.READY
  }
}
