package zio.aws.securitylake.model
import zio.aws.securitylake.model.primitives.{
  UpdateSubscriberRequestSubscriberNameString,
  UUID,
  DescriptionString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSubscriberRequest(
    sources: Optional[Iterable[zio.aws.securitylake.model.LogSourceResource]] =
      Optional.Absent,
    subscriberDescription: Optional[DescriptionString] = Optional.Absent,
    subscriberId: UUID,
    subscriberIdentity: Optional[zio.aws.securitylake.model.AwsIdentity] =
      Optional.Absent,
    subscriberName: Optional[UpdateSubscriberRequestSubscriberNameString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest = {
    import UpdateSubscriberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest
      .builder()
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(
        subscriberDescription.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.subscriberDescription)
      .subscriberId(UUID.unwrap(subscriberId): java.lang.String)
      .optionallyWith(subscriberIdentity.map(value => value.buildAwsValue()))(
        _.subscriberIdentity
      )
      .optionallyWith(
        subscriberName.map(value =>
          UpdateSubscriberRequestSubscriberNameString.unwrap(
            value
          ): java.lang.String
        )
      )(_.subscriberName)
      .build()
  }
  def asReadOnly: zio.aws.securitylake.model.UpdateSubscriberRequest.ReadOnly =
    zio.aws.securitylake.model.UpdateSubscriberRequest.wrap(buildAwsValue())
}
object UpdateSubscriberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securitylake.model.UpdateSubscriberRequest =
      zio.aws.securitylake.model.UpdateSubscriberRequest(
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subscriberDescription.map(value => value),
        subscriberId,
        subscriberIdentity.map(value => value.asEditable),
        subscriberName.map(value => value)
      )
    def sources
        : Optional[List[zio.aws.securitylake.model.LogSourceResource.ReadOnly]]
    def subscriberDescription: Optional[DescriptionString]
    def subscriberId: UUID
    def subscriberIdentity
        : Optional[zio.aws.securitylake.model.AwsIdentity.ReadOnly]
    def subscriberName: Optional[UpdateSubscriberRequestSubscriberNameString]
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.securitylake.model.LogSourceResource.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getSubscriberDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("subscriberDescription", subscriberDescription)
    def getSubscriberId: ZIO[Any, Nothing, UUID] = ZIO.succeed(subscriberId)
    def getSubscriberIdentity
        : ZIO[Any, AwsError, zio.aws.securitylake.model.AwsIdentity.ReadOnly] =
      AwsError.unwrapOptionField("subscriberIdentity", subscriberIdentity)
    def getSubscriberName
        : ZIO[Any, AwsError, UpdateSubscriberRequestSubscriberNameString] =
      AwsError.unwrapOptionField("subscriberName", subscriberName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest
  ) extends zio.aws.securitylake.model.UpdateSubscriberRequest.ReadOnly {
    override val sources: Optional[
      List[zio.aws.securitylake.model.LogSourceResource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securitylake.model.LogSourceResource.wrap(item)
        }.toList
      )
    override val subscriberDescription: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriberDescription())
        .map(value =>
          zio.aws.securitylake.model.primitives.DescriptionString(value)
        )
    override val subscriberId: UUID =
      zio.aws.securitylake.model.primitives.UUID(impl.subscriberId())
    override val subscriberIdentity
        : Optional[zio.aws.securitylake.model.AwsIdentity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriberIdentity())
        .map(value => zio.aws.securitylake.model.AwsIdentity.wrap(value))
    override val subscriberName
        : Optional[UpdateSubscriberRequestSubscriberNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriberName())
        .map(value =>
          zio.aws.securitylake.model.primitives
            .UpdateSubscriberRequestSubscriberNameString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest
  ): zio.aws.securitylake.model.UpdateSubscriberRequest.ReadOnly = new Wrapper(
    impl
  )
}
