package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Body(
    text: Option[zio.aws.ses.model.Content] = None,
    html: Option[zio.aws.ses.model.Content] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ses.model.Body = {
    import Body.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.Body
      .builder()
      .optionallyWith(text.map(value => value.buildAwsValue()))(_.text)
      .optionallyWith(html.map(value => value.buildAwsValue()))(_.html)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.Body.ReadOnly =
    zio.aws.ses.model.Body.wrap(buildAwsValue())
}
object Body {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.Body] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.Body = zio.aws.ses.model.Body(
      text.map(value => value.asEditable),
      html.map(value => value.asEditable)
    )
    def text: Option[zio.aws.ses.model.Content.ReadOnly]
    def html: Option[zio.aws.ses.model.Content.ReadOnly]
    def getText: ZIO[Any, AwsError, zio.aws.ses.model.Content.ReadOnly] =
      AwsError.unwrapOptionField("text", text)
    def getHtml: ZIO[Any, AwsError, zio.aws.ses.model.Content.ReadOnly] =
      AwsError.unwrapOptionField("html", html)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.Body
  ) extends zio.aws.ses.model.Body.ReadOnly {
    override val text: Option[zio.aws.ses.model.Content.ReadOnly] = scala
      .Option(impl.text())
      .map(value => zio.aws.ses.model.Content.wrap(value))
    override val html: Option[zio.aws.ses.model.Content.ReadOnly] = scala
      .Option(impl.html())
      .map(value => zio.aws.ses.model.Content.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.Body
  ): zio.aws.ses.model.Body.ReadOnly = new Wrapper(impl)
}
