package zio.aws.ses.model
import zio.aws.ses.model.primitives.{DefaultDimensionValue, DimensionName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CloudWatchDimensionConfiguration(
    dimensionName: DimensionName,
    dimensionValueSource: zio.aws.ses.model.DimensionValueSource,
    defaultDimensionValue: DefaultDimensionValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfiguration = {
    import CloudWatchDimensionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfiguration
      .builder()
      .dimensionName(DimensionName.unwrap(dimensionName): java.lang.String)
      .dimensionValueSource(dimensionValueSource.unwrap)
      .defaultDimensionValue(
        DefaultDimensionValue.unwrap(defaultDimensionValue): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.CloudWatchDimensionConfiguration.ReadOnly =
    zio.aws.ses.model.CloudWatchDimensionConfiguration.wrap(buildAwsValue())
}
object CloudWatchDimensionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.CloudWatchDimensionConfiguration =
      zio.aws.ses.model.CloudWatchDimensionConfiguration(
        dimensionName,
        dimensionValueSource,
        defaultDimensionValue
      )
    def dimensionName: DimensionName
    def dimensionValueSource: zio.aws.ses.model.DimensionValueSource
    def defaultDimensionValue: DefaultDimensionValue
    def getDimensionName: ZIO[Any, Nothing, DimensionName] =
      ZIO.succeed(dimensionName)
    def getDimensionValueSource
        : ZIO[Any, Nothing, zio.aws.ses.model.DimensionValueSource] =
      ZIO.succeed(dimensionValueSource)
    def getDefaultDimensionValue: ZIO[Any, Nothing, DefaultDimensionValue] =
      ZIO.succeed(defaultDimensionValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfiguration
  ) extends zio.aws.ses.model.CloudWatchDimensionConfiguration.ReadOnly {
    override val dimensionName: DimensionName =
      zio.aws.ses.model.primitives.DimensionName(impl.dimensionName())
    override val dimensionValueSource: zio.aws.ses.model.DimensionValueSource =
      zio.aws.ses.model.DimensionValueSource.wrap(impl.dimensionValueSource())
    override val defaultDimensionValue: DefaultDimensionValue =
      zio.aws.ses.model.primitives
        .DefaultDimensionValue(impl.defaultDimensionValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfiguration
  ): zio.aws.ses.model.CloudWatchDimensionConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
