package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  TemplateName,
  FromAddress,
  TemplateContent,
  FailureRedirectionURL,
  SuccessRedirectionURL,
  Subject
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetCustomVerificationEmailTemplateResponse(
    templateName: Option[TemplateName] = None,
    fromEmailAddress: Option[FromAddress] = None,
    templateSubject: Option[Subject] = None,
    templateContent: Option[TemplateContent] = None,
    successRedirectionURL: Option[SuccessRedirectionURL] = None,
    failureRedirectionURL: Option[FailureRedirectionURL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateResponse = {
    import GetCustomVerificationEmailTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateResponse
      .builder()
      .optionallyWith(
        templateName.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.templateName)
      .optionallyWith(
        fromEmailAddress.map(value =>
          FromAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .optionallyWith(
        templateSubject.map(value => Subject.unwrap(value): java.lang.String)
      )(_.templateSubject)
      .optionallyWith(
        templateContent.map(value =>
          TemplateContent.unwrap(value): java.lang.String
        )
      )(_.templateContent)
      .optionallyWith(
        successRedirectionURL.map(value =>
          SuccessRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.successRedirectionURL)
      .optionallyWith(
        failureRedirectionURL.map(value =>
          FailureRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.failureRedirectionURL)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.GetCustomVerificationEmailTemplateResponse.ReadOnly =
    zio.aws.ses.model.GetCustomVerificationEmailTemplateResponse
      .wrap(buildAwsValue())
}
object GetCustomVerificationEmailTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.GetCustomVerificationEmailTemplateResponse =
      zio.aws.ses.model.GetCustomVerificationEmailTemplateResponse(
        templateName.map(value => value),
        fromEmailAddress.map(value => value),
        templateSubject.map(value => value),
        templateContent.map(value => value),
        successRedirectionURL.map(value => value),
        failureRedirectionURL.map(value => value)
      )
    def templateName: Option[TemplateName]
    def fromEmailAddress: Option[FromAddress]
    def templateSubject: Option[Subject]
    def templateContent: Option[TemplateContent]
    def successRedirectionURL: Option[SuccessRedirectionURL]
    def failureRedirectionURL: Option[FailureRedirectionURL]
    def getTemplateName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getFromEmailAddress: ZIO[Any, AwsError, FromAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getTemplateSubject: ZIO[Any, AwsError, Subject] =
      AwsError.unwrapOptionField("templateSubject", templateSubject)
    def getTemplateContent: ZIO[Any, AwsError, TemplateContent] =
      AwsError.unwrapOptionField("templateContent", templateContent)
    def getSuccessRedirectionURL: ZIO[Any, AwsError, SuccessRedirectionURL] =
      AwsError.unwrapOptionField("successRedirectionURL", successRedirectionURL)
    def getFailureRedirectionURL: ZIO[Any, AwsError, FailureRedirectionURL] =
      AwsError.unwrapOptionField("failureRedirectionURL", failureRedirectionURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateResponse
  ) extends zio.aws.ses.model.GetCustomVerificationEmailTemplateResponse.ReadOnly {
    override val templateName: Option[TemplateName] = scala
      .Option(impl.templateName())
      .map(value => zio.aws.ses.model.primitives.TemplateName(value))
    override val fromEmailAddress: Option[FromAddress] = scala
      .Option(impl.fromEmailAddress())
      .map(value => zio.aws.ses.model.primitives.FromAddress(value))
    override val templateSubject: Option[Subject] = scala
      .Option(impl.templateSubject())
      .map(value => zio.aws.ses.model.primitives.Subject(value))
    override val templateContent: Option[TemplateContent] = scala
      .Option(impl.templateContent())
      .map(value => zio.aws.ses.model.primitives.TemplateContent(value))
    override val successRedirectionURL: Option[SuccessRedirectionURL] = scala
      .Option(impl.successRedirectionURL())
      .map(value => zio.aws.ses.model.primitives.SuccessRedirectionURL(value))
    override val failureRedirectionURL: Option[FailureRedirectionURL] = scala
      .Option(impl.failureRedirectionURL())
      .map(value => zio.aws.ses.model.primitives.FailureRedirectionURL(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateResponse
  ): zio.aws.ses.model.GetCustomVerificationEmailTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
