package zio.aws.ses.model
import java.lang.Integer
import zio.aws.ses.model.primitives.{MaxItems, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListIdentitiesRequest(
    identityType: Option[zio.aws.ses.model.IdentityType] = None,
    nextToken: Option[NextToken] = None,
    maxItems: Option[MaxItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListIdentitiesRequest = {
    import ListIdentitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListIdentitiesRequest
      .builder()
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ListIdentitiesRequest.ReadOnly =
    zio.aws.ses.model.ListIdentitiesRequest.wrap(buildAwsValue())
}
object ListIdentitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListIdentitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ListIdentitiesRequest =
      zio.aws.ses.model.ListIdentitiesRequest(
        identityType.map(value => value),
        nextToken.map(value => value),
        maxItems.map(value => value)
      )
    def identityType: Option[zio.aws.ses.model.IdentityType]
    def nextToken: Option[NextToken]
    def maxItems: Option[MaxItems]
    def getIdentityType: ZIO[Any, AwsError, zio.aws.ses.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListIdentitiesRequest
  ) extends zio.aws.ses.model.ListIdentitiesRequest.ReadOnly {
    override val identityType: Option[zio.aws.ses.model.IdentityType] = scala
      .Option(impl.identityType())
      .map(value => zio.aws.ses.model.IdentityType.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ses.model.primitives.NextToken(value))
    override val maxItems: Option[MaxItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.ses.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListIdentitiesRequest
  ): zio.aws.ses.model.ListIdentitiesRequest.ReadOnly = new Wrapper(impl)
}
