package zio.aws.ses.model
import java.lang.Integer
import zio.aws.ses.model.primitives.{MaxItems, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTemplatesRequest(
    nextToken: Option[NextToken] = None,
    maxItems: Option[MaxItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListTemplatesRequest = {
    import ListTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListTemplatesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ListTemplatesRequest.ReadOnly =
    zio.aws.ses.model.ListTemplatesRequest.wrap(buildAwsValue())
}
object ListTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ListTemplatesRequest =
      zio.aws.ses.model.ListTemplatesRequest(
        nextToken.map(value => value),
        maxItems.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxItems: Option[MaxItems]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListTemplatesRequest
  ) extends zio.aws.ses.model.ListTemplatesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ses.model.primitives.NextToken(value))
    override val maxItems: Option[MaxItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.ses.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListTemplatesRequest
  ): zio.aws.ses.model.ListTemplatesRequest.ReadOnly = new Wrapper(impl)
}
