package zio.aws.ses.model
import zio.aws.ses.model.primitives.Address
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListVerifiedEmailAddressesResponse(
    verifiedEmailAddresses: Option[Iterable[Address]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListVerifiedEmailAddressesResponse = {
    import ListVerifiedEmailAddressesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListVerifiedEmailAddressesResponse
      .builder()
      .optionallyWith(
        verifiedEmailAddresses.map(value =>
          value.map { item =>
            Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.verifiedEmailAddresses)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.ListVerifiedEmailAddressesResponse.ReadOnly =
    zio.aws.ses.model.ListVerifiedEmailAddressesResponse.wrap(buildAwsValue())
}
object ListVerifiedEmailAddressesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListVerifiedEmailAddressesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ListVerifiedEmailAddressesResponse =
      zio.aws.ses.model.ListVerifiedEmailAddressesResponse(
        verifiedEmailAddresses.map(value => value)
      )
    def verifiedEmailAddresses: Option[List[Address]]
    def getVerifiedEmailAddresses: ZIO[Any, AwsError, List[Address]] = AwsError
      .unwrapOptionField("verifiedEmailAddresses", verifiedEmailAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListVerifiedEmailAddressesResponse
  ) extends zio.aws.ses.model.ListVerifiedEmailAddressesResponse.ReadOnly {
    override val verifiedEmailAddresses: Option[List[Address]] = scala
      .Option(impl.verifiedEmailAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.primitives.Address(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListVerifiedEmailAddressesResponse
  ): zio.aws.ses.model.ListVerifiedEmailAddressesResponse.ReadOnly =
    new Wrapper(impl)
}
