package zio.aws.ses.model
import zio.aws.ses.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutConfigurationSetDeliveryOptionsRequest(
    configurationSetName: ConfigurationSetName,
    deliveryOptions: Option[zio.aws.ses.model.DeliveryOptions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.PutConfigurationSetDeliveryOptionsRequest = {
    import PutConfigurationSetDeliveryOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.PutConfigurationSetDeliveryOptionsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(deliveryOptions.map(value => value.buildAwsValue()))(
        _.deliveryOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.PutConfigurationSetDeliveryOptionsRequest.ReadOnly =
    zio.aws.ses.model.PutConfigurationSetDeliveryOptionsRequest
      .wrap(buildAwsValue())
}
object PutConfigurationSetDeliveryOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.PutConfigurationSetDeliveryOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.PutConfigurationSetDeliveryOptionsRequest =
      zio.aws.ses.model.PutConfigurationSetDeliveryOptionsRequest(
        configurationSetName,
        deliveryOptions.map(value => value.asEditable)
      )
    def configurationSetName: ConfigurationSetName
    def deliveryOptions: Option[zio.aws.ses.model.DeliveryOptions.ReadOnly]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getDeliveryOptions
        : ZIO[Any, AwsError, zio.aws.ses.model.DeliveryOptions.ReadOnly] =
      AwsError.unwrapOptionField("deliveryOptions", deliveryOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.PutConfigurationSetDeliveryOptionsRequest
  ) extends zio.aws.ses.model.PutConfigurationSetDeliveryOptionsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.ses.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val deliveryOptions
        : Option[zio.aws.ses.model.DeliveryOptions.ReadOnly] = scala
      .Option(impl.deliveryOptions())
      .map(value => zio.aws.ses.model.DeliveryOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.PutConfigurationSetDeliveryOptionsRequest
  ): zio.aws.ses.model.PutConfigurationSetDeliveryOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
