package zio.aws.ses.model
import zio.aws.ses.model.primitives.RawMessageData
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RawMessage(data: RawMessageData) {
  def buildAwsValue(): software.amazon.awssdk.services.ses.model.RawMessage = {
    import RawMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.RawMessage
      .builder()
      .data(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(data.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.RawMessage.ReadOnly =
    zio.aws.ses.model.RawMessage.wrap(buildAwsValue())
}
object RawMessage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.RawMessage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.RawMessage =
      zio.aws.ses.model.RawMessage(data)
    def data: RawMessageData
    def getData: ZIO[Any, Nothing, RawMessageData] = ZIO.succeed(data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.RawMessage
  ) extends zio.aws.ses.model.RawMessage.ReadOnly {
    override val data: RawMessageData = zio.aws.ses.model.primitives
      .RawMessageData(zio.Chunk.fromArray(impl.data().asByteArrayUnsafe()))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.RawMessage
  ): zio.aws.ses.model.RawMessage.ReadOnly = new Wrapper(impl)
}
