package zio.aws.ses.model
import zio.aws.ses.model.primitives.{LastFreshStart, Enabled}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ReputationOptions(
    sendingEnabled: Option[Enabled] = None,
    reputationMetricsEnabled: Option[Enabled] = None,
    lastFreshStart: Option[LastFreshStart] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ReputationOptions = {
    import ReputationOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ReputationOptions
      .builder()
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .optionallyWith(
        reputationMetricsEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.reputationMetricsEnabled)
      .optionallyWith(
        lastFreshStart.map(value => LastFreshStart.unwrap(value): Instant)
      )(_.lastFreshStart)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ReputationOptions.ReadOnly =
    zio.aws.ses.model.ReputationOptions.wrap(buildAwsValue())
}
object ReputationOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ReputationOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ReputationOptions =
      zio.aws.ses.model.ReputationOptions(
        sendingEnabled.map(value => value),
        reputationMetricsEnabled.map(value => value),
        lastFreshStart.map(value => value)
      )
    def sendingEnabled: Option[Enabled]
    def reputationMetricsEnabled: Option[Enabled]
    def lastFreshStart: Option[LastFreshStart]
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
    def getReputationMetricsEnabled: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("reputationMetricsEnabled", reputationMetricsEnabled)
    def getLastFreshStart: ZIO[Any, AwsError, LastFreshStart] =
      AwsError.unwrapOptionField("lastFreshStart", lastFreshStart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ReputationOptions
  ) extends zio.aws.ses.model.ReputationOptions.ReadOnly {
    override val sendingEnabled: Option[Enabled] = scala
      .Option(impl.sendingEnabled())
      .map(value => zio.aws.ses.model.primitives.Enabled(value))
    override val reputationMetricsEnabled: Option[Enabled] = scala
      .Option(impl.reputationMetricsEnabled())
      .map(value => zio.aws.ses.model.primitives.Enabled(value))
    override val lastFreshStart: Option[LastFreshStart] = scala
      .Option(impl.lastFreshStart())
      .map(value => zio.aws.ses.model.primitives.LastFreshStart(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ReputationOptions
  ): zio.aws.ses.model.ReputationOptions.ReadOnly = new Wrapper(impl)
}
