package zio.aws.ses.model
import zio.aws.ses.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SNSAction(
    topicArn: AmazonResourceName,
    encoding: Option[zio.aws.ses.model.SNSActionEncoding] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ses.model.SNSAction = {
    import SNSAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SNSAction
      .builder()
      .topicArn(AmazonResourceName.unwrap(topicArn): java.lang.String)
      .optionallyWith(encoding.map(value => value.unwrap))(_.encoding)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SNSAction.ReadOnly =
    zio.aws.ses.model.SNSAction.wrap(buildAwsValue())
}
object SNSAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.SNSAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SNSAction =
      zio.aws.ses.model.SNSAction(topicArn, encoding.map(value => value))
    def topicArn: AmazonResourceName
    def encoding: Option[zio.aws.ses.model.SNSActionEncoding]
    def getTopicArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(topicArn)
    def getEncoding: ZIO[Any, AwsError, zio.aws.ses.model.SNSActionEncoding] =
      AwsError.unwrapOptionField("encoding", encoding)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SNSAction
  ) extends zio.aws.ses.model.SNSAction.ReadOnly {
    override val topicArn: AmazonResourceName =
      zio.aws.ses.model.primitives.AmazonResourceName(impl.topicArn())
    override val encoding: Option[zio.aws.ses.model.SNSActionEncoding] = scala
      .Option(impl.encoding())
      .map(value => zio.aws.ses.model.SNSActionEncoding.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SNSAction
  ): zio.aws.ses.model.SNSAction.ReadOnly = new Wrapper(impl)
}
