package zio.aws.ses.model
import zio.aws.ses.model.primitives.{ReceiptRuleName, ReceiptRuleSetName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SetReceiptRulePositionRequest(
    ruleSetName: ReceiptRuleSetName,
    ruleName: ReceiptRuleName,
    after: Option[ReceiptRuleName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SetReceiptRulePositionRequest = {
    import SetReceiptRulePositionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SetReceiptRulePositionRequest
      .builder()
      .ruleSetName(ReceiptRuleSetName.unwrap(ruleSetName): java.lang.String)
      .ruleName(ReceiptRuleName.unwrap(ruleName): java.lang.String)
      .optionallyWith(
        after.map(value => ReceiptRuleName.unwrap(value): java.lang.String)
      )(_.after)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SetReceiptRulePositionRequest.ReadOnly =
    zio.aws.ses.model.SetReceiptRulePositionRequest.wrap(buildAwsValue())
}
object SetReceiptRulePositionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SetReceiptRulePositionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SetReceiptRulePositionRequest =
      zio.aws.ses.model.SetReceiptRulePositionRequest(
        ruleSetName,
        ruleName,
        after.map(value => value)
      )
    def ruleSetName: ReceiptRuleSetName
    def ruleName: ReceiptRuleName
    def after: Option[ReceiptRuleName]
    def getRuleSetName: ZIO[Any, Nothing, ReceiptRuleSetName] =
      ZIO.succeed(ruleSetName)
    def getRuleName: ZIO[Any, Nothing, ReceiptRuleName] = ZIO.succeed(ruleName)
    def getAfter: ZIO[Any, AwsError, ReceiptRuleName] =
      AwsError.unwrapOptionField("after", after)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SetReceiptRulePositionRequest
  ) extends zio.aws.ses.model.SetReceiptRulePositionRequest.ReadOnly {
    override val ruleSetName: ReceiptRuleSetName =
      zio.aws.ses.model.primitives.ReceiptRuleSetName(impl.ruleSetName())
    override val ruleName: ReceiptRuleName =
      zio.aws.ses.model.primitives.ReceiptRuleName(impl.ruleName())
    override val after: Option[ReceiptRuleName] = scala
      .Option(impl.after())
      .map(value => zio.aws.ses.model.primitives.ReceiptRuleName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SetReceiptRulePositionRequest
  ): zio.aws.ses.model.SetReceiptRulePositionRequest.ReadOnly = new Wrapper(
    impl
  )
}
