package zio.aws.ses.model
import zio.aws.ses.model.primitives.{Timestamp, TemplateName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TemplateMetadata(
    name: Option[TemplateName] = None,
    createdTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.TemplateMetadata = {
    import TemplateMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.TemplateMetadata
      .builder()
      .optionallyWith(
        name.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.TemplateMetadata.ReadOnly =
    zio.aws.ses.model.TemplateMetadata.wrap(buildAwsValue())
}
object TemplateMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.TemplateMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.TemplateMetadata =
      zio.aws.ses.model.TemplateMetadata(
        name.map(value => value),
        createdTimestamp.map(value => value)
      )
    def name: Option[TemplateName]
    def createdTimestamp: Option[Timestamp]
    def getName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.TemplateMetadata
  ) extends zio.aws.ses.model.TemplateMetadata.ReadOnly {
    override val name: Option[TemplateName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ses.model.primitives.TemplateName(value))
    override val createdTimestamp: Option[Timestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.ses.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.TemplateMetadata
  ): zio.aws.ses.model.TemplateMetadata.ReadOnly = new Wrapper(impl)
}
