package zio.aws.ses.model
import zio.aws.ses.model.primitives.Enabled
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateAccountSendingEnabledRequest(
    enabled: Option[Enabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledRequest = {
    import UpdateAccountSendingEnabledRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledRequest
      .builder()
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.UpdateAccountSendingEnabledRequest.ReadOnly =
    zio.aws.ses.model.UpdateAccountSendingEnabledRequest.wrap(buildAwsValue())
}
object UpdateAccountSendingEnabledRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.UpdateAccountSendingEnabledRequest =
      zio.aws.ses.model
        .UpdateAccountSendingEnabledRequest(enabled.map(value => value))
    def enabled: Option[Enabled]
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledRequest
  ) extends zio.aws.ses.model.UpdateAccountSendingEnabledRequest.ReadOnly {
    override val enabled: Option[Enabled] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.ses.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledRequest
  ): zio.aws.ses.model.UpdateAccountSendingEnabledRequest.ReadOnly =
    new Wrapper(impl)
}
