package zio.aws.ses
import zio.aws.ses.model.GetIdentityMailFromDomainAttributesResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.ses.model.{
  ListReceiptRuleSetsRequest,
  ListIdentityPoliciesRequest,
  DeleteVerifiedEmailAddressRequest,
  TestRenderTemplateRequest,
  SetIdentityHeadersInNotificationsEnabledRequest,
  ReorderReceiptRuleSetRequest,
  CreateReceiptRuleSetRequest,
  CreateConfigurationSetTrackingOptionsRequest,
  VerifyDomainIdentityRequest,
  DescribeActiveReceiptRuleSetRequest,
  ListIdentitiesRequest,
  VerifyEmailIdentityRequest,
  SetReceiptRulePositionRequest,
  GetIdentityMailFromDomainAttributesRequest,
  DeleteConfigurationSetRequest,
  SetIdentityFeedbackForwardingEnabledRequest,
  UpdateConfigurationSetEventDestinationRequest,
  DeleteCustomVerificationEmailTemplateRequest,
  DeleteReceiptFilterRequest,
  SetActiveReceiptRuleSetRequest,
  GetIdentityDkimAttributesRequest,
  DescribeConfigurationSetRequest,
  DeleteTemplateRequest,
  DeleteReceiptRuleRequest,
  UpdateAccountSendingEnabledRequest,
  VerifyEmailAddressRequest,
  ListReceiptFiltersRequest,
  GetIdentityPoliciesRequest,
  CreateReceiptFilterRequest,
  CreateConfigurationSetRequest,
  PutIdentityPolicyRequest,
  SendTemplatedEmailRequest,
  UpdateReceiptRuleRequest,
  UpdateConfigurationSetReputationMetricsEnabledRequest,
  DeleteReceiptRuleSetRequest,
  SetIdentityMailFromDomainRequest,
  GetIdentityVerificationAttributesRequest,
  SendEmailRequest,
  CreateReceiptRuleRequest,
  PutConfigurationSetDeliveryOptionsRequest,
  ListConfigurationSetsRequest,
  CloneReceiptRuleSetRequest,
  UpdateCustomVerificationEmailTemplateRequest,
  DeleteIdentityRequest,
  SendRawEmailRequest,
  DescribeReceiptRuleSetRequest,
  CreateConfigurationSetEventDestinationRequest,
  UpdateConfigurationSetTrackingOptionsRequest,
  ListCustomVerificationEmailTemplatesRequest,
  SetIdentityDkimEnabledRequest,
  DeleteConfigurationSetEventDestinationRequest,
  UpdateTemplateRequest,
  UpdateConfigurationSetSendingEnabledRequest,
  DeleteIdentityPolicyRequest,
  VerifyDomainDkimRequest,
  ListTemplatesRequest,
  DeleteConfigurationSetTrackingOptionsRequest,
  SendCustomVerificationEmailRequest,
  GetTemplateRequest,
  DescribeReceiptRuleRequest,
  SendBulkTemplatedEmailRequest,
  SetIdentityNotificationTopicRequest,
  CreateCustomVerificationEmailTemplateRequest,
  CreateTemplateRequest,
  GetIdentityNotificationAttributesRequest,
  GetCustomVerificationEmailTemplateRequest,
  SendBounceRequest
}
import zio.aws.ses.model.primitives.Identity
import software.amazon.awssdk.services.ses.{
  SesAsyncClientBuilder,
  SesAsyncClient
}
import zio.stream.ZStream
import software.amazon.awssdk.services.ses.model.{
  ListReceiptFiltersResponse,
  DeleteReceiptRuleResponse,
  CreateReceiptRuleSetResponse,
  DescribeActiveReceiptRuleSetResponse,
  SetIdentityFeedbackForwardingEnabledResponse,
  DeleteConfigurationSetEventDestinationResponse,
  DeleteTemplateResponse,
  SendBounceResponse,
  CreateReceiptFilterResponse,
  GetSendStatisticsRequest,
  GetCustomVerificationEmailTemplateResponse,
  DeleteConfigurationSetResponse,
  SendEmailResponse,
  DeleteReceiptFilterResponse,
  VerifyEmailIdentityResponse,
  ListConfigurationSetsResponse,
  ListTemplatesResponse,
  CreateConfigurationSetEventDestinationResponse,
  SetReceiptRulePositionResponse,
  SetIdentityDkimEnabledResponse,
  GetIdentityPoliciesResponse,
  SetIdentityNotificationTopicResponse,
  VerifyDomainDkimResponse,
  GetTemplateResponse,
  UpdateAccountSendingEnabledResponse,
  GetAccountSendingEnabledResponse,
  CustomVerificationEmailTemplate,
  CloneReceiptRuleSetResponse,
  DeleteIdentityPolicyResponse,
  UpdateConfigurationSetTrackingOptionsResponse,
  GetAccountSendingEnabledRequest,
  ListIdentitiesResponse,
  ReceiptRuleSetMetadata,
  CreateTemplateResponse,
  CreateConfigurationSetResponse,
  UpdateConfigurationSetEventDestinationResponse,
  UpdateConfigurationSetReputationMetricsEnabledResponse,
  GetIdentityDkimAttributesResponse,
  DeleteCustomVerificationEmailTemplateResponse,
  CreateCustomVerificationEmailTemplateResponse,
  SendCustomVerificationEmailResponse,
  UpdateCustomVerificationEmailTemplateResponse,
  GetSendQuotaResponse,
  TemplateMetadata,
  DeleteReceiptRuleSetResponse,
  UpdateTemplateResponse,
  GetSendQuotaRequest,
  CreateConfigurationSetTrackingOptionsResponse,
  ListReceiptRuleSetsResponse,
  DeleteVerifiedEmailAddressResponse,
  ListVerifiedEmailAddressesResponse,
  DescribeReceiptRuleSetResponse,
  SetIdentityMailFromDomainResponse,
  UpdateConfigurationSetSendingEnabledResponse,
  SetIdentityHeadersInNotificationsEnabledResponse,
  DescribeReceiptRuleResponse,
  TestRenderTemplateResponse,
  UpdateReceiptRuleResponse,
  SendBulkTemplatedEmailResponse,
  GetSendStatisticsResponse,
  CreateReceiptRuleResponse,
  PutConfigurationSetDeliveryOptionsResponse,
  GetIdentityVerificationAttributesResponse,
  ListVerifiedEmailAddressesRequest,
  PutIdentityPolicyResponse,
  SetActiveReceiptRuleSetResponse,
  ConfigurationSet,
  GetIdentityMailFromDomainAttributesResponse,
  ReorderReceiptRuleSetResponse,
  DescribeConfigurationSetResponse,
  ListCustomVerificationEmailTemplatesResponse,
  DeleteConfigurationSetTrackingOptionsResponse,
  ListIdentityPoliciesResponse,
  GetIdentityNotificationAttributesResponse,
  SendRawEmailResponse,
  VerifyEmailAddressResponse,
  DeleteIdentityResponse,
  SendTemplatedEmailResponse,
  VerifyDomainIdentityResponse
}
import scala.jdk.CollectionConverters._
trait Ses extends AspectSupport[Ses] {
  val api: SesAsyncClient
  def deleteConfigurationSetTrackingOptions(
      request: DeleteConfigurationSetTrackingOptionsRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.DeleteConfigurationSetTrackingOptionsResponse.ReadOnly
  ]
  def deleteReceiptRule(
      request: DeleteReceiptRuleRequest
  ): IO[AwsError, zio.aws.ses.model.DeleteReceiptRuleResponse.ReadOnly]
  def createReceiptFilter(
      request: CreateReceiptFilterRequest
  ): IO[AwsError, zio.aws.ses.model.CreateReceiptFilterResponse.ReadOnly]
  def createConfigurationSetEventDestination(
      request: CreateConfigurationSetEventDestinationRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.CreateConfigurationSetEventDestinationResponse.ReadOnly
  ]
  def getIdentityDkimAttributes(
      request: GetIdentityDkimAttributesRequest
  ): IO[AwsError, zio.aws.ses.model.GetIdentityDkimAttributesResponse.ReadOnly]
  def setIdentityFeedbackForwardingEnabled(
      request: SetIdentityFeedbackForwardingEnabledRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.SetIdentityFeedbackForwardingEnabledResponse.ReadOnly
  ]
  def updateTemplate(
      request: UpdateTemplateRequest
  ): IO[AwsError, zio.aws.ses.model.UpdateTemplateResponse.ReadOnly]
  def listIdentityPolicies(
      request: ListIdentityPoliciesRequest
  ): IO[AwsError, zio.aws.ses.model.ListIdentityPoliciesResponse.ReadOnly]
  def listIdentities(
      request: ListIdentitiesRequest
  ): ZStream[Any, AwsError, Identity]
  def listIdentitiesPaginated(
      request: ListIdentitiesRequest
  ): IO[AwsError, zio.aws.ses.model.ListIdentitiesResponse.ReadOnly]
  def setIdentityNotificationTopic(
      request: SetIdentityNotificationTopicRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.SetIdentityNotificationTopicResponse.ReadOnly
  ]
  def sendEmail(
      request: SendEmailRequest
  ): IO[AwsError, zio.aws.ses.model.SendEmailResponse.ReadOnly]
  def createCustomVerificationEmailTemplate(
      request: CreateCustomVerificationEmailTemplateRequest
  ): IO[AwsError, Unit]
  def testRenderTemplate(
      request: TestRenderTemplateRequest
  ): IO[AwsError, zio.aws.ses.model.TestRenderTemplateResponse.ReadOnly]
  def createReceiptRuleSet(
      request: CreateReceiptRuleSetRequest
  ): IO[AwsError, zio.aws.ses.model.CreateReceiptRuleSetResponse.ReadOnly]
  def createTemplate(
      request: CreateTemplateRequest
  ): IO[AwsError, zio.aws.ses.model.CreateTemplateResponse.ReadOnly]
  def describeConfigurationSet(
      request: DescribeConfigurationSetRequest
  ): IO[AwsError, zio.aws.ses.model.DescribeConfigurationSetResponse.ReadOnly]
  def deleteIdentity(
      request: DeleteIdentityRequest
  ): IO[AwsError, zio.aws.ses.model.DeleteIdentityResponse.ReadOnly]
  def deleteTemplate(
      request: DeleteTemplateRequest
  ): IO[AwsError, zio.aws.ses.model.DeleteTemplateResponse.ReadOnly]
  def putIdentityPolicy(
      request: PutIdentityPolicyRequest
  ): IO[AwsError, zio.aws.ses.model.PutIdentityPolicyResponse.ReadOnly]
  def updateConfigurationSetTrackingOptions(
      request: UpdateConfigurationSetTrackingOptionsRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.UpdateConfigurationSetTrackingOptionsResponse.ReadOnly
  ]
  def sendBulkTemplatedEmail(
      request: SendBulkTemplatedEmailRequest
  ): IO[AwsError, zio.aws.ses.model.SendBulkTemplatedEmailResponse.ReadOnly]
  def setIdentityHeadersInNotificationsEnabled(
      request: SetIdentityHeadersInNotificationsEnabledRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.SetIdentityHeadersInNotificationsEnabledResponse.ReadOnly
  ]
  def describeReceiptRule(
      request: DescribeReceiptRuleRequest
  ): IO[AwsError, zio.aws.ses.model.DescribeReceiptRuleResponse.ReadOnly]
  def sendTemplatedEmail(
      request: SendTemplatedEmailRequest
  ): IO[AwsError, zio.aws.ses.model.SendTemplatedEmailResponse.ReadOnly]
  def setIdentityDkimEnabled(
      request: SetIdentityDkimEnabledRequest
  ): IO[AwsError, zio.aws.ses.model.SetIdentityDkimEnabledResponse.ReadOnly]
  def listTemplates(
      request: ListTemplatesRequest
  ): ZStream[Any, AwsError, zio.aws.ses.model.TemplateMetadata.ReadOnly]
  def listTemplatesPaginated(
      request: ListTemplatesRequest
  ): IO[AwsError, zio.aws.ses.model.ListTemplatesResponse.ReadOnly]
  def getSendStatistics()
      : IO[AwsError, zio.aws.ses.model.GetSendStatisticsResponse.ReadOnly]
  def deleteVerifiedEmailAddress(
      request: DeleteVerifiedEmailAddressRequest
  ): IO[AwsError, Unit]
  def verifyDomainDkim(
      request: VerifyDomainDkimRequest
  ): IO[AwsError, zio.aws.ses.model.VerifyDomainDkimResponse.ReadOnly]
  def getIdentityVerificationAttributes(
      request: GetIdentityVerificationAttributesRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.GetIdentityVerificationAttributesResponse.ReadOnly
  ]
  def describeReceiptRuleSet(
      request: DescribeReceiptRuleSetRequest
  ): IO[AwsError, zio.aws.ses.model.DescribeReceiptRuleSetResponse.ReadOnly]
  def getIdentityMailFromDomainAttributes(
      request: GetIdentityMailFromDomainAttributesRequest
  ): IO[AwsError, ReadOnly]
  def listCustomVerificationEmailTemplates(
      request: ListCustomVerificationEmailTemplatesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly
  ]
  def listCustomVerificationEmailTemplatesPaginated(
      request: ListCustomVerificationEmailTemplatesRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly
  ]
  def cloneReceiptRuleSet(
      request: CloneReceiptRuleSetRequest
  ): IO[AwsError, zio.aws.ses.model.CloneReceiptRuleSetResponse.ReadOnly]
  def listReceiptFilters(
      request: ListReceiptFiltersRequest
  ): IO[AwsError, zio.aws.ses.model.ListReceiptFiltersResponse.ReadOnly]
  def describeActiveReceiptRuleSet(
      request: DescribeActiveReceiptRuleSetRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.DescribeActiveReceiptRuleSetResponse.ReadOnly
  ]
  def deleteReceiptRuleSet(
      request: DeleteReceiptRuleSetRequest
  ): IO[AwsError, zio.aws.ses.model.DeleteReceiptRuleSetResponse.ReadOnly]
  def setActiveReceiptRuleSet(
      request: SetActiveReceiptRuleSetRequest
  ): IO[AwsError, zio.aws.ses.model.SetActiveReceiptRuleSetResponse.ReadOnly]
  def getIdentityNotificationAttributes(
      request: GetIdentityNotificationAttributesRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.GetIdentityNotificationAttributesResponse.ReadOnly
  ]
  def verifyEmailIdentity(
      request: VerifyEmailIdentityRequest
  ): IO[AwsError, zio.aws.ses.model.VerifyEmailIdentityResponse.ReadOnly]
  def deleteReceiptFilter(
      request: DeleteReceiptFilterRequest
  ): IO[AwsError, zio.aws.ses.model.DeleteReceiptFilterResponse.ReadOnly]
  def updateCustomVerificationEmailTemplate(
      request: UpdateCustomVerificationEmailTemplateRequest
  ): IO[AwsError, Unit]
  def updateReceiptRule(
      request: UpdateReceiptRuleRequest
  ): IO[AwsError, zio.aws.ses.model.UpdateReceiptRuleResponse.ReadOnly]
  def listConfigurationSets(
      request: ListConfigurationSetsRequest
  ): ZStream[Any, AwsError, zio.aws.ses.model.ConfigurationSet.ReadOnly]
  def listConfigurationSetsPaginated(
      request: ListConfigurationSetsRequest
  ): IO[AwsError, zio.aws.ses.model.ListConfigurationSetsResponse.ReadOnly]
  def reorderReceiptRuleSet(
      request: ReorderReceiptRuleSetRequest
  ): IO[AwsError, zio.aws.ses.model.ReorderReceiptRuleSetResponse.ReadOnly]
  def createConfigurationSetTrackingOptions(
      request: CreateConfigurationSetTrackingOptionsRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.CreateConfigurationSetTrackingOptionsResponse.ReadOnly
  ]
  def deleteCustomVerificationEmailTemplate(
      request: DeleteCustomVerificationEmailTemplateRequest
  ): IO[AwsError, Unit]
  def listVerifiedEmailAddresses(): IO[
    AwsError,
    zio.aws.ses.model.ListVerifiedEmailAddressesResponse.ReadOnly
  ]
  def updateConfigurationSetSendingEnabled(
      request: UpdateConfigurationSetSendingEnabledRequest
  ): IO[AwsError, Unit]
  def verifyEmailAddress(request: VerifyEmailAddressRequest): IO[AwsError, Unit]
  def getAccountSendingEnabled(): IO[
    AwsError,
    zio.aws.ses.model.GetAccountSendingEnabledResponse.ReadOnly
  ]
  def deleteConfigurationSet(
      request: DeleteConfigurationSetRequest
  ): IO[AwsError, zio.aws.ses.model.DeleteConfigurationSetResponse.ReadOnly]
  def createConfigurationSet(
      request: CreateConfigurationSetRequest
  ): IO[AwsError, zio.aws.ses.model.CreateConfigurationSetResponse.ReadOnly]
  def sendRawEmail(
      request: SendRawEmailRequest
  ): IO[AwsError, zio.aws.ses.model.SendRawEmailResponse.ReadOnly]
  def updateAccountSendingEnabled(
      request: UpdateAccountSendingEnabledRequest
  ): IO[AwsError, Unit]
  def listReceiptRuleSets(
      request: ListReceiptRuleSetsRequest
  ): ZStream[Any, AwsError, zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly]
  def listReceiptRuleSetsPaginated(
      request: ListReceiptRuleSetsRequest
  ): IO[AwsError, zio.aws.ses.model.ListReceiptRuleSetsResponse.ReadOnly]
  def verifyDomainIdentity(
      request: VerifyDomainIdentityRequest
  ): IO[AwsError, zio.aws.ses.model.VerifyDomainIdentityResponse.ReadOnly]
  def createReceiptRule(
      request: CreateReceiptRuleRequest
  ): IO[AwsError, zio.aws.ses.model.CreateReceiptRuleResponse.ReadOnly]
  def deleteIdentityPolicy(
      request: DeleteIdentityPolicyRequest
  ): IO[AwsError, zio.aws.ses.model.DeleteIdentityPolicyResponse.ReadOnly]
  def updateConfigurationSetEventDestination(
      request: UpdateConfigurationSetEventDestinationRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
  ]
  def getIdentityPolicies(
      request: GetIdentityPoliciesRequest
  ): IO[AwsError, zio.aws.ses.model.GetIdentityPoliciesResponse.ReadOnly]
  def updateConfigurationSetReputationMetricsEnabled(
      request: UpdateConfigurationSetReputationMetricsEnabledRequest
  ): IO[AwsError, Unit]
  def setIdentityMailFromDomain(
      request: SetIdentityMailFromDomainRequest
  ): IO[AwsError, zio.aws.ses.model.SetIdentityMailFromDomainResponse.ReadOnly]
  def getCustomVerificationEmailTemplate(
      request: GetCustomVerificationEmailTemplateRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.GetCustomVerificationEmailTemplateResponse.ReadOnly
  ]
  def sendCustomVerificationEmail(
      request: SendCustomVerificationEmailRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.SendCustomVerificationEmailResponse.ReadOnly
  ]
  def sendBounce(
      request: SendBounceRequest
  ): IO[AwsError, zio.aws.ses.model.SendBounceResponse.ReadOnly]
  def getSendQuota()
      : IO[AwsError, zio.aws.ses.model.GetSendQuotaResponse.ReadOnly]
  def putConfigurationSetDeliveryOptions(
      request: PutConfigurationSetDeliveryOptionsRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
  ]
  def getTemplate(
      request: GetTemplateRequest
  ): IO[AwsError, zio.aws.ses.model.GetTemplateResponse.ReadOnly]
  def setReceiptRulePosition(
      request: SetReceiptRulePositionRequest
  ): IO[AwsError, zio.aws.ses.model.SetReceiptRulePositionResponse.ReadOnly]
  def deleteConfigurationSetEventDestination(
      request: DeleteConfigurationSetEventDestinationRequest
  ): IO[
    AwsError,
    zio.aws.ses.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
  ]
}
object Ses {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Ses] = customized(identity)
  def customized(
      customization: SesAsyncClientBuilder => SesAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Ses] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SesAsyncClientBuilder => SesAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Ses] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SesAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[SesAsyncClient, SesAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[SesAsyncClient, SesAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new SesImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SesImpl[R](
      override val api: SesAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Ses
      with AwsServiceBase[R] {
    override val serviceName: String = "Ses"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SesImpl[R1] = new SesImpl(api, newAspect, r)
    def deleteConfigurationSetTrackingOptions(
        request: DeleteConfigurationSetTrackingOptionsRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.DeleteConfigurationSetTrackingOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.DeleteConfigurationSetTrackingOptionsRequest,
      DeleteConfigurationSetTrackingOptionsResponse
    ](
      "deleteConfigurationSetTrackingOptions",
      api.deleteConfigurationSetTrackingOptions
    )(request.buildAwsValue())
      .map(zio.aws.ses.model.DeleteConfigurationSetTrackingOptionsResponse.wrap)
      .provideEnvironment(r)
    def deleteReceiptRule(
        request: DeleteReceiptRuleRequest
    ): IO[AwsError, zio.aws.ses.model.DeleteReceiptRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.DeleteReceiptRuleRequest,
        DeleteReceiptRuleResponse
      ]("deleteReceiptRule", api.deleteReceiptRule)(request.buildAwsValue())
        .map(zio.aws.ses.model.DeleteReceiptRuleResponse.wrap)
        .provideEnvironment(r)
    def createReceiptFilter(
        request: CreateReceiptFilterRequest
    ): IO[AwsError, zio.aws.ses.model.CreateReceiptFilterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.CreateReceiptFilterRequest,
        CreateReceiptFilterResponse
      ]("createReceiptFilter", api.createReceiptFilter)(request.buildAwsValue())
        .map(zio.aws.ses.model.CreateReceiptFilterResponse.wrap)
        .provideEnvironment(r)
    def createConfigurationSetEventDestination(
        request: CreateConfigurationSetEventDestinationRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.CreateConfigurationSetEventDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationRequest,
      CreateConfigurationSetEventDestinationResponse
    ](
      "createConfigurationSetEventDestination",
      api.createConfigurationSetEventDestination
    )(request.buildAwsValue())
      .map(
        zio.aws.ses.model.CreateConfigurationSetEventDestinationResponse.wrap
      )
      .provideEnvironment(r)
    def getIdentityDkimAttributes(
        request: GetIdentityDkimAttributesRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.GetIdentityDkimAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.GetIdentityDkimAttributesRequest,
      GetIdentityDkimAttributesResponse
    ]("getIdentityDkimAttributes", api.getIdentityDkimAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.ses.model.GetIdentityDkimAttributesResponse.wrap)
      .provideEnvironment(r)
    def setIdentityFeedbackForwardingEnabled(
        request: SetIdentityFeedbackForwardingEnabledRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.SetIdentityFeedbackForwardingEnabledResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest,
      SetIdentityFeedbackForwardingEnabledResponse
    ](
      "setIdentityFeedbackForwardingEnabled",
      api.setIdentityFeedbackForwardingEnabled
    )(request.buildAwsValue())
      .map(zio.aws.ses.model.SetIdentityFeedbackForwardingEnabledResponse.wrap)
      .provideEnvironment(r)
    def updateTemplate(
        request: UpdateTemplateRequest
    ): IO[AwsError, zio.aws.ses.model.UpdateTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.UpdateTemplateRequest,
        UpdateTemplateResponse
      ]("updateTemplate", api.updateTemplate)(request.buildAwsValue())
        .map(zio.aws.ses.model.UpdateTemplateResponse.wrap)
        .provideEnvironment(r)
    def listIdentityPolicies(
        request: ListIdentityPoliciesRequest
    ): IO[AwsError, zio.aws.ses.model.ListIdentityPoliciesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.ListIdentityPoliciesRequest,
        ListIdentityPoliciesResponse
      ]("listIdentityPolicies", api.listIdentityPolicies)(
        request.buildAwsValue()
      ).map(zio.aws.ses.model.ListIdentityPoliciesResponse.wrap)
        .provideEnvironment(r)
    def listIdentities(
        request: ListIdentitiesRequest
    ): ZStream[Any, AwsError, Identity] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.ses.model.ListIdentitiesRequest,
      ListIdentitiesResponse,
      java.lang.String
    ](
      "listIdentities",
      api.listIdentities,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.identities().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ses.model.primitives.Identity(item))
      .provideEnvironment(r)
    def listIdentitiesPaginated(
        request: ListIdentitiesRequest
    ): IO[AwsError, zio.aws.ses.model.ListIdentitiesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.ListIdentitiesRequest,
        ListIdentitiesResponse
      ]("listIdentities", api.listIdentities)(request.buildAwsValue())
        .map(zio.aws.ses.model.ListIdentitiesResponse.wrap)
        .provideEnvironment(r)
    def setIdentityNotificationTopic(
        request: SetIdentityNotificationTopicRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.SetIdentityNotificationTopicResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicRequest,
      SetIdentityNotificationTopicResponse
    ]("setIdentityNotificationTopic", api.setIdentityNotificationTopic)(
      request.buildAwsValue()
    ).map(zio.aws.ses.model.SetIdentityNotificationTopicResponse.wrap)
      .provideEnvironment(r)
    def sendEmail(
        request: SendEmailRequest
    ): IO[AwsError, zio.aws.ses.model.SendEmailResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.SendEmailRequest,
        SendEmailResponse
      ]("sendEmail", api.sendEmail)(request.buildAwsValue())
        .map(zio.aws.ses.model.SendEmailResponse.wrap)
        .provideEnvironment(r)
    def createCustomVerificationEmailTemplate(
        request: CreateCustomVerificationEmailTemplateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.CreateCustomVerificationEmailTemplateRequest,
      CreateCustomVerificationEmailTemplateResponse
    ](
      "createCustomVerificationEmailTemplate",
      api.createCustomVerificationEmailTemplate
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def testRenderTemplate(
        request: TestRenderTemplateRequest
    ): IO[AwsError, zio.aws.ses.model.TestRenderTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.TestRenderTemplateRequest,
        TestRenderTemplateResponse
      ]("testRenderTemplate", api.testRenderTemplate)(request.buildAwsValue())
        .map(zio.aws.ses.model.TestRenderTemplateResponse.wrap)
        .provideEnvironment(r)
    def createReceiptRuleSet(
        request: CreateReceiptRuleSetRequest
    ): IO[AwsError, zio.aws.ses.model.CreateReceiptRuleSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetRequest,
        CreateReceiptRuleSetResponse
      ]("createReceiptRuleSet", api.createReceiptRuleSet)(
        request.buildAwsValue()
      ).map(zio.aws.ses.model.CreateReceiptRuleSetResponse.wrap)
        .provideEnvironment(r)
    def createTemplate(
        request: CreateTemplateRequest
    ): IO[AwsError, zio.aws.ses.model.CreateTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.CreateTemplateRequest,
        CreateTemplateResponse
      ]("createTemplate", api.createTemplate)(request.buildAwsValue())
        .map(zio.aws.ses.model.CreateTemplateResponse.wrap)
        .provideEnvironment(r)
    def describeConfigurationSet(request: DescribeConfigurationSetRequest): IO[
      AwsError,
      zio.aws.ses.model.DescribeConfigurationSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.DescribeConfigurationSetRequest,
      DescribeConfigurationSetResponse
    ]("describeConfigurationSet", api.describeConfigurationSet)(
      request.buildAwsValue()
    ).map(zio.aws.ses.model.DescribeConfigurationSetResponse.wrap)
      .provideEnvironment(r)
    def deleteIdentity(
        request: DeleteIdentityRequest
    ): IO[AwsError, zio.aws.ses.model.DeleteIdentityResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.DeleteIdentityRequest,
        DeleteIdentityResponse
      ]("deleteIdentity", api.deleteIdentity)(request.buildAwsValue())
        .map(zio.aws.ses.model.DeleteIdentityResponse.wrap)
        .provideEnvironment(r)
    def deleteTemplate(
        request: DeleteTemplateRequest
    ): IO[AwsError, zio.aws.ses.model.DeleteTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.DeleteTemplateRequest,
        DeleteTemplateResponse
      ]("deleteTemplate", api.deleteTemplate)(request.buildAwsValue())
        .map(zio.aws.ses.model.DeleteTemplateResponse.wrap)
        .provideEnvironment(r)
    def putIdentityPolicy(
        request: PutIdentityPolicyRequest
    ): IO[AwsError, zio.aws.ses.model.PutIdentityPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.PutIdentityPolicyRequest,
        PutIdentityPolicyResponse
      ]("putIdentityPolicy", api.putIdentityPolicy)(request.buildAwsValue())
        .map(zio.aws.ses.model.PutIdentityPolicyResponse.wrap)
        .provideEnvironment(r)
    def updateConfigurationSetTrackingOptions(
        request: UpdateConfigurationSetTrackingOptionsRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.UpdateConfigurationSetTrackingOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest,
      UpdateConfigurationSetTrackingOptionsResponse
    ](
      "updateConfigurationSetTrackingOptions",
      api.updateConfigurationSetTrackingOptions
    )(request.buildAwsValue())
      .map(zio.aws.ses.model.UpdateConfigurationSetTrackingOptionsResponse.wrap)
      .provideEnvironment(r)
    def sendBulkTemplatedEmail(
        request: SendBulkTemplatedEmailRequest
    ): IO[AwsError, zio.aws.ses.model.SendBulkTemplatedEmailResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailRequest,
        SendBulkTemplatedEmailResponse
      ]("sendBulkTemplatedEmail", api.sendBulkTemplatedEmail)(
        request.buildAwsValue()
      ).map(zio.aws.ses.model.SendBulkTemplatedEmailResponse.wrap)
        .provideEnvironment(r)
    def setIdentityHeadersInNotificationsEnabled(
        request: SetIdentityHeadersInNotificationsEnabledRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.SetIdentityHeadersInNotificationsEnabledResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.SetIdentityHeadersInNotificationsEnabledRequest,
      SetIdentityHeadersInNotificationsEnabledResponse
    ](
      "setIdentityHeadersInNotificationsEnabled",
      api.setIdentityHeadersInNotificationsEnabled
    )(request.buildAwsValue())
      .map(
        zio.aws.ses.model.SetIdentityHeadersInNotificationsEnabledResponse.wrap
      )
      .provideEnvironment(r)
    def describeReceiptRule(
        request: DescribeReceiptRuleRequest
    ): IO[AwsError, zio.aws.ses.model.DescribeReceiptRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.DescribeReceiptRuleRequest,
        DescribeReceiptRuleResponse
      ]("describeReceiptRule", api.describeReceiptRule)(request.buildAwsValue())
        .map(zio.aws.ses.model.DescribeReceiptRuleResponse.wrap)
        .provideEnvironment(r)
    def sendTemplatedEmail(
        request: SendTemplatedEmailRequest
    ): IO[AwsError, zio.aws.ses.model.SendTemplatedEmailResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.SendTemplatedEmailRequest,
        SendTemplatedEmailResponse
      ]("sendTemplatedEmail", api.sendTemplatedEmail)(request.buildAwsValue())
        .map(zio.aws.ses.model.SendTemplatedEmailResponse.wrap)
        .provideEnvironment(r)
    def setIdentityDkimEnabled(
        request: SetIdentityDkimEnabledRequest
    ): IO[AwsError, zio.aws.ses.model.SetIdentityDkimEnabledResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledRequest,
        SetIdentityDkimEnabledResponse
      ]("setIdentityDkimEnabled", api.setIdentityDkimEnabled)(
        request.buildAwsValue()
      ).map(zio.aws.ses.model.SetIdentityDkimEnabledResponse.wrap)
        .provideEnvironment(r)
    def listTemplates(
        request: ListTemplatesRequest
    ): ZStream[Any, AwsError, zio.aws.ses.model.TemplateMetadata.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.ses.model.ListTemplatesRequest,
        ListTemplatesResponse,
        TemplateMetadata
      ](
        "listTemplates",
        api.listTemplates,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.templatesMetadata().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ses.model.TemplateMetadata.wrap(item))
        .provideEnvironment(r)
    def listTemplatesPaginated(
        request: ListTemplatesRequest
    ): IO[AwsError, zio.aws.ses.model.ListTemplatesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.ListTemplatesRequest,
        ListTemplatesResponse
      ]("listTemplates", api.listTemplates)(request.buildAwsValue())
        .map(zio.aws.ses.model.ListTemplatesResponse.wrap)
        .provideEnvironment(r)
    def getSendStatistics()
        : IO[AwsError, zio.aws.ses.model.GetSendStatisticsResponse.ReadOnly] =
      asyncRequestResponse[GetSendStatisticsRequest, GetSendStatisticsResponse](
        "getSendStatistics",
        api.getSendStatistics
      )(GetSendStatisticsRequest.builder().build())
        .map(zio.aws.ses.model.GetSendStatisticsResponse.wrap)
        .provideEnvironment(r)
    def deleteVerifiedEmailAddress(
        request: DeleteVerifiedEmailAddressRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressRequest,
      DeleteVerifiedEmailAddressResponse
    ]("deleteVerifiedEmailAddress", api.deleteVerifiedEmailAddress)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def verifyDomainDkim(
        request: VerifyDomainDkimRequest
    ): IO[AwsError, zio.aws.ses.model.VerifyDomainDkimResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.VerifyDomainDkimRequest,
        VerifyDomainDkimResponse
      ]("verifyDomainDkim", api.verifyDomainDkim)(request.buildAwsValue())
        .map(zio.aws.ses.model.VerifyDomainDkimResponse.wrap)
        .provideEnvironment(r)
    def getIdentityVerificationAttributes(
        request: GetIdentityVerificationAttributesRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.GetIdentityVerificationAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest,
      GetIdentityVerificationAttributesResponse
    ](
      "getIdentityVerificationAttributes",
      api.getIdentityVerificationAttributes
    )(request.buildAwsValue())
      .map(zio.aws.ses.model.GetIdentityVerificationAttributesResponse.wrap)
      .provideEnvironment(r)
    def describeReceiptRuleSet(
        request: DescribeReceiptRuleSetRequest
    ): IO[AwsError, zio.aws.ses.model.DescribeReceiptRuleSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.DescribeReceiptRuleSetRequest,
        DescribeReceiptRuleSetResponse
      ]("describeReceiptRuleSet", api.describeReceiptRuleSet)(
        request.buildAwsValue()
      ).map(zio.aws.ses.model.DescribeReceiptRuleSetResponse.wrap)
        .provideEnvironment(r)
    def getIdentityMailFromDomainAttributes(
        request: GetIdentityMailFromDomainAttributesRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesRequest,
      GetIdentityMailFromDomainAttributesResponse
    ](
      "getIdentityMailFromDomainAttributes",
      api.getIdentityMailFromDomainAttributes
    )(request.buildAwsValue())
      .map(zio.aws.ses.model.GetIdentityMailFromDomainAttributesResponse.wrap)
      .provideEnvironment(r)
    def listCustomVerificationEmailTemplates(
        request: ListCustomVerificationEmailTemplatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest,
      ListCustomVerificationEmailTemplatesResponse,
      CustomVerificationEmailTemplate
    ](
      "listCustomVerificationEmailTemplates",
      api.listCustomVerificationEmailTemplates,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.customVerificationEmailTemplates().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ses.model.CustomVerificationEmailTemplate.wrap(item))
      .provideEnvironment(r)
    def listCustomVerificationEmailTemplatesPaginated(
        request: ListCustomVerificationEmailTemplatesRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest,
      ListCustomVerificationEmailTemplatesResponse
    ](
      "listCustomVerificationEmailTemplates",
      api.listCustomVerificationEmailTemplates
    )(request.buildAwsValue())
      .map(zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse.wrap)
      .provideEnvironment(r)
    def cloneReceiptRuleSet(
        request: CloneReceiptRuleSetRequest
    ): IO[AwsError, zio.aws.ses.model.CloneReceiptRuleSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetRequest,
        CloneReceiptRuleSetResponse
      ]("cloneReceiptRuleSet", api.cloneReceiptRuleSet)(request.buildAwsValue())
        .map(zio.aws.ses.model.CloneReceiptRuleSetResponse.wrap)
        .provideEnvironment(r)
    def listReceiptFilters(
        request: ListReceiptFiltersRequest
    ): IO[AwsError, zio.aws.ses.model.ListReceiptFiltersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.ListReceiptFiltersRequest,
        ListReceiptFiltersResponse
      ]("listReceiptFilters", api.listReceiptFilters)(request.buildAwsValue())
        .map(zio.aws.ses.model.ListReceiptFiltersResponse.wrap)
        .provideEnvironment(r)
    def describeActiveReceiptRuleSet(
        request: DescribeActiveReceiptRuleSetRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.DescribeActiveReceiptRuleSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetRequest,
      DescribeActiveReceiptRuleSetResponse
    ]("describeActiveReceiptRuleSet", api.describeActiveReceiptRuleSet)(
      request.buildAwsValue()
    ).map(zio.aws.ses.model.DescribeActiveReceiptRuleSetResponse.wrap)
      .provideEnvironment(r)
    def deleteReceiptRuleSet(
        request: DeleteReceiptRuleSetRequest
    ): IO[AwsError, zio.aws.ses.model.DeleteReceiptRuleSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetRequest,
        DeleteReceiptRuleSetResponse
      ]("deleteReceiptRuleSet", api.deleteReceiptRuleSet)(
        request.buildAwsValue()
      ).map(zio.aws.ses.model.DeleteReceiptRuleSetResponse.wrap)
        .provideEnvironment(r)
    def setActiveReceiptRuleSet(request: SetActiveReceiptRuleSetRequest): IO[
      AwsError,
      zio.aws.ses.model.SetActiveReceiptRuleSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetRequest,
      SetActiveReceiptRuleSetResponse
    ]("setActiveReceiptRuleSet", api.setActiveReceiptRuleSet)(
      request.buildAwsValue()
    ).map(zio.aws.ses.model.SetActiveReceiptRuleSetResponse.wrap)
      .provideEnvironment(r)
    def getIdentityNotificationAttributes(
        request: GetIdentityNotificationAttributesRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.GetIdentityNotificationAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesRequest,
      GetIdentityNotificationAttributesResponse
    ](
      "getIdentityNotificationAttributes",
      api.getIdentityNotificationAttributes
    )(request.buildAwsValue())
      .map(zio.aws.ses.model.GetIdentityNotificationAttributesResponse.wrap)
      .provideEnvironment(r)
    def verifyEmailIdentity(
        request: VerifyEmailIdentityRequest
    ): IO[AwsError, zio.aws.ses.model.VerifyEmailIdentityResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.VerifyEmailIdentityRequest,
        VerifyEmailIdentityResponse
      ]("verifyEmailIdentity", api.verifyEmailIdentity)(request.buildAwsValue())
        .map(zio.aws.ses.model.VerifyEmailIdentityResponse.wrap)
        .provideEnvironment(r)
    def deleteReceiptFilter(
        request: DeleteReceiptFilterRequest
    ): IO[AwsError, zio.aws.ses.model.DeleteReceiptFilterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.DeleteReceiptFilterRequest,
        DeleteReceiptFilterResponse
      ]("deleteReceiptFilter", api.deleteReceiptFilter)(request.buildAwsValue())
        .map(zio.aws.ses.model.DeleteReceiptFilterResponse.wrap)
        .provideEnvironment(r)
    def updateCustomVerificationEmailTemplate(
        request: UpdateCustomVerificationEmailTemplateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest,
      UpdateCustomVerificationEmailTemplateResponse
    ](
      "updateCustomVerificationEmailTemplate",
      api.updateCustomVerificationEmailTemplate
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateReceiptRule(
        request: UpdateReceiptRuleRequest
    ): IO[AwsError, zio.aws.ses.model.UpdateReceiptRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.UpdateReceiptRuleRequest,
        UpdateReceiptRuleResponse
      ]("updateReceiptRule", api.updateReceiptRule)(request.buildAwsValue())
        .map(zio.aws.ses.model.UpdateReceiptRuleResponse.wrap)
        .provideEnvironment(r)
    def listConfigurationSets(
        request: ListConfigurationSetsRequest
    ): ZStream[Any, AwsError, zio.aws.ses.model.ConfigurationSet.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest,
        ListConfigurationSetsResponse,
        ConfigurationSet
      ](
        "listConfigurationSets",
        api.listConfigurationSets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.configurationSets().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ses.model.ConfigurationSet.wrap(item))
        .provideEnvironment(r)
    def listConfigurationSetsPaginated(
        request: ListConfigurationSetsRequest
    ): IO[AwsError, zio.aws.ses.model.ListConfigurationSetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest,
        ListConfigurationSetsResponse
      ]("listConfigurationSets", api.listConfigurationSets)(
        request.buildAwsValue()
      ).map(zio.aws.ses.model.ListConfigurationSetsResponse.wrap)
        .provideEnvironment(r)
    def reorderReceiptRuleSet(
        request: ReorderReceiptRuleSetRequest
    ): IO[AwsError, zio.aws.ses.model.ReorderReceiptRuleSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetRequest,
        ReorderReceiptRuleSetResponse
      ]("reorderReceiptRuleSet", api.reorderReceiptRuleSet)(
        request.buildAwsValue()
      ).map(zio.aws.ses.model.ReorderReceiptRuleSetResponse.wrap)
        .provideEnvironment(r)
    def createConfigurationSetTrackingOptions(
        request: CreateConfigurationSetTrackingOptionsRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.CreateConfigurationSetTrackingOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.CreateConfigurationSetTrackingOptionsRequest,
      CreateConfigurationSetTrackingOptionsResponse
    ](
      "createConfigurationSetTrackingOptions",
      api.createConfigurationSetTrackingOptions
    )(request.buildAwsValue())
      .map(zio.aws.ses.model.CreateConfigurationSetTrackingOptionsResponse.wrap)
      .provideEnvironment(r)
    def deleteCustomVerificationEmailTemplate(
        request: DeleteCustomVerificationEmailTemplateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateRequest,
      DeleteCustomVerificationEmailTemplateResponse
    ](
      "deleteCustomVerificationEmailTemplate",
      api.deleteCustomVerificationEmailTemplate
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listVerifiedEmailAddresses(): IO[
      AwsError,
      zio.aws.ses.model.ListVerifiedEmailAddressesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListVerifiedEmailAddressesRequest,
      ListVerifiedEmailAddressesResponse
    ]("listVerifiedEmailAddresses", api.listVerifiedEmailAddresses)(
      ListVerifiedEmailAddressesRequest.builder().build()
    ).map(zio.aws.ses.model.ListVerifiedEmailAddressesResponse.wrap)
      .provideEnvironment(r)
    def updateConfigurationSetSendingEnabled(
        request: UpdateConfigurationSetSendingEnabledRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledRequest,
      UpdateConfigurationSetSendingEnabledResponse
    ](
      "updateConfigurationSetSendingEnabled",
      api.updateConfigurationSetSendingEnabled
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def verifyEmailAddress(
        request: VerifyEmailAddressRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.VerifyEmailAddressRequest,
      VerifyEmailAddressResponse
    ]("verifyEmailAddress", api.verifyEmailAddress)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getAccountSendingEnabled(): IO[
      AwsError,
      zio.aws.ses.model.GetAccountSendingEnabledResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAccountSendingEnabledRequest,
      GetAccountSendingEnabledResponse
    ]("getAccountSendingEnabled", api.getAccountSendingEnabled)(
      GetAccountSendingEnabledRequest.builder().build()
    ).map(zio.aws.ses.model.GetAccountSendingEnabledResponse.wrap)
      .provideEnvironment(r)
    def deleteConfigurationSet(
        request: DeleteConfigurationSetRequest
    ): IO[AwsError, zio.aws.ses.model.DeleteConfigurationSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.DeleteConfigurationSetRequest,
        DeleteConfigurationSetResponse
      ]("deleteConfigurationSet", api.deleteConfigurationSet)(
        request.buildAwsValue()
      ).map(zio.aws.ses.model.DeleteConfigurationSetResponse.wrap)
        .provideEnvironment(r)
    def createConfigurationSet(
        request: CreateConfigurationSetRequest
    ): IO[AwsError, zio.aws.ses.model.CreateConfigurationSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.CreateConfigurationSetRequest,
        CreateConfigurationSetResponse
      ]("createConfigurationSet", api.createConfigurationSet)(
        request.buildAwsValue()
      ).map(zio.aws.ses.model.CreateConfigurationSetResponse.wrap)
        .provideEnvironment(r)
    def sendRawEmail(
        request: SendRawEmailRequest
    ): IO[AwsError, zio.aws.ses.model.SendRawEmailResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.SendRawEmailRequest,
        SendRawEmailResponse
      ]("sendRawEmail", api.sendRawEmail)(request.buildAwsValue())
        .map(zio.aws.ses.model.SendRawEmailResponse.wrap)
        .provideEnvironment(r)
    def updateAccountSendingEnabled(
        request: UpdateAccountSendingEnabledRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.UpdateAccountSendingEnabledRequest,
      UpdateAccountSendingEnabledResponse
    ]("updateAccountSendingEnabled", api.updateAccountSendingEnabled)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listReceiptRuleSets(request: ListReceiptRuleSetsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsRequest,
      ListReceiptRuleSetsResponse,
      ReceiptRuleSetMetadata
    ](
      "listReceiptRuleSets",
      api.listReceiptRuleSets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.ruleSets().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ses.model.ReceiptRuleSetMetadata.wrap(item))
      .provideEnvironment(r)
    def listReceiptRuleSetsPaginated(
        request: ListReceiptRuleSetsRequest
    ): IO[AwsError, zio.aws.ses.model.ListReceiptRuleSetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsRequest,
        ListReceiptRuleSetsResponse
      ]("listReceiptRuleSets", api.listReceiptRuleSets)(request.buildAwsValue())
        .map(zio.aws.ses.model.ListReceiptRuleSetsResponse.wrap)
        .provideEnvironment(r)
    def verifyDomainIdentity(
        request: VerifyDomainIdentityRequest
    ): IO[AwsError, zio.aws.ses.model.VerifyDomainIdentityResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.VerifyDomainIdentityRequest,
        VerifyDomainIdentityResponse
      ]("verifyDomainIdentity", api.verifyDomainIdentity)(
        request.buildAwsValue()
      ).map(zio.aws.ses.model.VerifyDomainIdentityResponse.wrap)
        .provideEnvironment(r)
    def createReceiptRule(
        request: CreateReceiptRuleRequest
    ): IO[AwsError, zio.aws.ses.model.CreateReceiptRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.CreateReceiptRuleRequest,
        CreateReceiptRuleResponse
      ]("createReceiptRule", api.createReceiptRule)(request.buildAwsValue())
        .map(zio.aws.ses.model.CreateReceiptRuleResponse.wrap)
        .provideEnvironment(r)
    def deleteIdentityPolicy(
        request: DeleteIdentityPolicyRequest
    ): IO[AwsError, zio.aws.ses.model.DeleteIdentityPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.DeleteIdentityPolicyRequest,
        DeleteIdentityPolicyResponse
      ]("deleteIdentityPolicy", api.deleteIdentityPolicy)(
        request.buildAwsValue()
      ).map(zio.aws.ses.model.DeleteIdentityPolicyResponse.wrap)
        .provideEnvironment(r)
    def updateConfigurationSetEventDestination(
        request: UpdateConfigurationSetEventDestinationRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationRequest,
      UpdateConfigurationSetEventDestinationResponse
    ](
      "updateConfigurationSetEventDestination",
      api.updateConfigurationSetEventDestination
    )(request.buildAwsValue())
      .map(
        zio.aws.ses.model.UpdateConfigurationSetEventDestinationResponse.wrap
      )
      .provideEnvironment(r)
    def getIdentityPolicies(
        request: GetIdentityPoliciesRequest
    ): IO[AwsError, zio.aws.ses.model.GetIdentityPoliciesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.GetIdentityPoliciesRequest,
        GetIdentityPoliciesResponse
      ]("getIdentityPolicies", api.getIdentityPolicies)(request.buildAwsValue())
        .map(zio.aws.ses.model.GetIdentityPoliciesResponse.wrap)
        .provideEnvironment(r)
    def updateConfigurationSetReputationMetricsEnabled(
        request: UpdateConfigurationSetReputationMetricsEnabledRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.UpdateConfigurationSetReputationMetricsEnabledRequest,
      UpdateConfigurationSetReputationMetricsEnabledResponse
    ](
      "updateConfigurationSetReputationMetricsEnabled",
      api.updateConfigurationSetReputationMetricsEnabled
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def setIdentityMailFromDomain(
        request: SetIdentityMailFromDomainRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.SetIdentityMailFromDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.SetIdentityMailFromDomainRequest,
      SetIdentityMailFromDomainResponse
    ]("setIdentityMailFromDomain", api.setIdentityMailFromDomain)(
      request.buildAwsValue()
    ).map(zio.aws.ses.model.SetIdentityMailFromDomainResponse.wrap)
      .provideEnvironment(r)
    def getCustomVerificationEmailTemplate(
        request: GetCustomVerificationEmailTemplateRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.GetCustomVerificationEmailTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateRequest,
      GetCustomVerificationEmailTemplateResponse
    ](
      "getCustomVerificationEmailTemplate",
      api.getCustomVerificationEmailTemplate
    )(request.buildAwsValue())
      .map(zio.aws.ses.model.GetCustomVerificationEmailTemplateResponse.wrap)
      .provideEnvironment(r)
    def sendCustomVerificationEmail(
        request: SendCustomVerificationEmailRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.SendCustomVerificationEmailResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailRequest,
      SendCustomVerificationEmailResponse
    ]("sendCustomVerificationEmail", api.sendCustomVerificationEmail)(
      request.buildAwsValue()
    ).map(zio.aws.ses.model.SendCustomVerificationEmailResponse.wrap)
      .provideEnvironment(r)
    def sendBounce(
        request: SendBounceRequest
    ): IO[AwsError, zio.aws.ses.model.SendBounceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.SendBounceRequest,
        SendBounceResponse
      ]("sendBounce", api.sendBounce)(request.buildAwsValue())
        .map(zio.aws.ses.model.SendBounceResponse.wrap)
        .provideEnvironment(r)
    def getSendQuota()
        : IO[AwsError, zio.aws.ses.model.GetSendQuotaResponse.ReadOnly] =
      asyncRequestResponse[GetSendQuotaRequest, GetSendQuotaResponse](
        "getSendQuota",
        api.getSendQuota
      )(GetSendQuotaRequest.builder().build())
        .map(zio.aws.ses.model.GetSendQuotaResponse.wrap)
        .provideEnvironment(r)
    def putConfigurationSetDeliveryOptions(
        request: PutConfigurationSetDeliveryOptionsRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.PutConfigurationSetDeliveryOptionsRequest,
      PutConfigurationSetDeliveryOptionsResponse
    ](
      "putConfigurationSetDeliveryOptions",
      api.putConfigurationSetDeliveryOptions
    )(request.buildAwsValue())
      .map(zio.aws.ses.model.PutConfigurationSetDeliveryOptionsResponse.wrap)
      .provideEnvironment(r)
    def getTemplate(
        request: GetTemplateRequest
    ): IO[AwsError, zio.aws.ses.model.GetTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.GetTemplateRequest,
        GetTemplateResponse
      ]("getTemplate", api.getTemplate)(request.buildAwsValue())
        .map(zio.aws.ses.model.GetTemplateResponse.wrap)
        .provideEnvironment(r)
    def setReceiptRulePosition(
        request: SetReceiptRulePositionRequest
    ): IO[AwsError, zio.aws.ses.model.SetReceiptRulePositionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ses.model.SetReceiptRulePositionRequest,
        SetReceiptRulePositionResponse
      ]("setReceiptRulePosition", api.setReceiptRulePosition)(
        request.buildAwsValue()
      ).map(zio.aws.ses.model.SetReceiptRulePositionResponse.wrap)
        .provideEnvironment(r)
    def deleteConfigurationSetEventDestination(
        request: DeleteConfigurationSetEventDestinationRequest
    ): IO[
      AwsError,
      zio.aws.ses.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationRequest,
      DeleteConfigurationSetEventDestinationResponse
    ](
      "deleteConfigurationSetEventDestination",
      api.deleteConfigurationSetEventDestination
    )(request.buildAwsValue())
      .map(
        zio.aws.ses.model.DeleteConfigurationSetEventDestinationResponse.wrap
      )
      .provideEnvironment(r)
  }
  def deleteConfigurationSetTrackingOptions(
      request: DeleteConfigurationSetTrackingOptionsRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.DeleteConfigurationSetTrackingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConfigurationSetTrackingOptions(request))
  def deleteReceiptRule(request: DeleteReceiptRuleRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.DeleteReceiptRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReceiptRule(request))
  def createReceiptFilter(request: CreateReceiptFilterRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.CreateReceiptFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReceiptFilter(request))
  def createConfigurationSetEventDestination(
      request: CreateConfigurationSetEventDestinationRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.CreateConfigurationSetEventDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConfigurationSetEventDestination(request))
  def getIdentityDkimAttributes(request: GetIdentityDkimAttributesRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.GetIdentityDkimAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIdentityDkimAttributes(request))
  def setIdentityFeedbackForwardingEnabled(
      request: SetIdentityFeedbackForwardingEnabledRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.SetIdentityFeedbackForwardingEnabledResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setIdentityFeedbackForwardingEnabled(request))
  def updateTemplate(request: UpdateTemplateRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.UpdateTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTemplate(request))
  def listIdentityPolicies(request: ListIdentityPoliciesRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.ListIdentityPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIdentityPolicies(request))
  def listIdentities(
      request: ListIdentitiesRequest
  ): ZStream[zio.aws.ses.Ses, AwsError, Identity] =
    ZStream.serviceWithStream(_.listIdentities(request))
  def listIdentitiesPaginated(request: ListIdentitiesRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.ListIdentitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIdentitiesPaginated(request))
  def setIdentityNotificationTopic(
      request: SetIdentityNotificationTopicRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.SetIdentityNotificationTopicResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setIdentityNotificationTopic(request))
  def sendEmail(request: SendEmailRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.SendEmailResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendEmail(request))
  def createCustomVerificationEmailTemplate(
      request: CreateCustomVerificationEmailTemplateRequest
  ): ZIO[zio.aws.ses.Ses, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createCustomVerificationEmailTemplate(request))
  def testRenderTemplate(request: TestRenderTemplateRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.TestRenderTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testRenderTemplate(request))
  def createReceiptRuleSet(request: CreateReceiptRuleSetRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.CreateReceiptRuleSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReceiptRuleSet(request))
  def createTemplate(request: CreateTemplateRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.CreateTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTemplate(request))
  def describeConfigurationSet(request: DescribeConfigurationSetRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.DescribeConfigurationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConfigurationSet(request))
  def deleteIdentity(request: DeleteIdentityRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.DeleteIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteIdentity(request))
  def deleteTemplate(request: DeleteTemplateRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.DeleteTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTemplate(request))
  def putIdentityPolicy(request: PutIdentityPolicyRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.PutIdentityPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putIdentityPolicy(request))
  def updateConfigurationSetTrackingOptions(
      request: UpdateConfigurationSetTrackingOptionsRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.UpdateConfigurationSetTrackingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConfigurationSetTrackingOptions(request))
  def sendBulkTemplatedEmail(request: SendBulkTemplatedEmailRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.SendBulkTemplatedEmailResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendBulkTemplatedEmail(request))
  def setIdentityHeadersInNotificationsEnabled(
      request: SetIdentityHeadersInNotificationsEnabledRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.SetIdentityHeadersInNotificationsEnabledResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setIdentityHeadersInNotificationsEnabled(request))
  def describeReceiptRule(request: DescribeReceiptRuleRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.DescribeReceiptRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReceiptRule(request))
  def sendTemplatedEmail(request: SendTemplatedEmailRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.SendTemplatedEmailResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendTemplatedEmail(request))
  def setIdentityDkimEnabled(request: SetIdentityDkimEnabledRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.SetIdentityDkimEnabledResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setIdentityDkimEnabled(request))
  def listTemplates(request: ListTemplatesRequest): ZStream[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.TemplateMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listTemplates(request))
  def listTemplatesPaginated(request: ListTemplatesRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.ListTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTemplatesPaginated(request))
  def getSendStatistics(): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.GetSendStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSendStatistics())
  def deleteVerifiedEmailAddress(
      request: DeleteVerifiedEmailAddressRequest
  ): ZIO[zio.aws.ses.Ses, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVerifiedEmailAddress(request))
  def verifyDomainDkim(request: VerifyDomainDkimRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.VerifyDomainDkimResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.verifyDomainDkim(request))
  def getIdentityVerificationAttributes(
      request: GetIdentityVerificationAttributesRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.GetIdentityVerificationAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIdentityVerificationAttributes(request))
  def describeReceiptRuleSet(request: DescribeReceiptRuleSetRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.DescribeReceiptRuleSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReceiptRuleSet(request))
  def getIdentityMailFromDomainAttributes(
      request: GetIdentityMailFromDomainAttributesRequest
  ): ZIO[zio.aws.ses.Ses, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getIdentityMailFromDomainAttributes(request))
  def listCustomVerificationEmailTemplates(
      request: ListCustomVerificationEmailTemplatesRequest
  ): ZStream[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly
  ] = ZStream.serviceWithStream(_.listCustomVerificationEmailTemplates(request))
  def listCustomVerificationEmailTemplatesPaginated(
      request: ListCustomVerificationEmailTemplatesRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.listCustomVerificationEmailTemplatesPaginated(request))
  def cloneReceiptRuleSet(request: CloneReceiptRuleSetRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.CloneReceiptRuleSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cloneReceiptRuleSet(request))
  def listReceiptFilters(request: ListReceiptFiltersRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.ListReceiptFiltersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReceiptFilters(request))
  def describeActiveReceiptRuleSet(
      request: DescribeActiveReceiptRuleSetRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.DescribeActiveReceiptRuleSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeActiveReceiptRuleSet(request))
  def deleteReceiptRuleSet(request: DeleteReceiptRuleSetRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.DeleteReceiptRuleSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReceiptRuleSet(request))
  def setActiveReceiptRuleSet(request: SetActiveReceiptRuleSetRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.SetActiveReceiptRuleSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setActiveReceiptRuleSet(request))
  def getIdentityNotificationAttributes(
      request: GetIdentityNotificationAttributesRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.GetIdentityNotificationAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIdentityNotificationAttributes(request))
  def verifyEmailIdentity(request: VerifyEmailIdentityRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.VerifyEmailIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.verifyEmailIdentity(request))
  def deleteReceiptFilter(request: DeleteReceiptFilterRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.DeleteReceiptFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReceiptFilter(request))
  def updateCustomVerificationEmailTemplate(
      request: UpdateCustomVerificationEmailTemplateRequest
  ): ZIO[zio.aws.ses.Ses, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateCustomVerificationEmailTemplate(request))
  def updateReceiptRule(request: UpdateReceiptRuleRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.UpdateReceiptRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateReceiptRule(request))
  def listConfigurationSets(request: ListConfigurationSetsRequest): ZStream[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.ConfigurationSet.ReadOnly
  ] = ZStream.serviceWithStream(_.listConfigurationSets(request))
  def listConfigurationSetsPaginated(
      request: ListConfigurationSetsRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.ListConfigurationSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConfigurationSetsPaginated(request))
  def reorderReceiptRuleSet(request: ReorderReceiptRuleSetRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.ReorderReceiptRuleSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.reorderReceiptRuleSet(request))
  def createConfigurationSetTrackingOptions(
      request: CreateConfigurationSetTrackingOptionsRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.CreateConfigurationSetTrackingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConfigurationSetTrackingOptions(request))
  def deleteCustomVerificationEmailTemplate(
      request: DeleteCustomVerificationEmailTemplateRequest
  ): ZIO[zio.aws.ses.Ses, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCustomVerificationEmailTemplate(request))
  def listVerifiedEmailAddresses(): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.ListVerifiedEmailAddressesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVerifiedEmailAddresses())
  def updateConfigurationSetSendingEnabled(
      request: UpdateConfigurationSetSendingEnabledRequest
  ): ZIO[zio.aws.ses.Ses, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateConfigurationSetSendingEnabled(request))
  def verifyEmailAddress(
      request: VerifyEmailAddressRequest
  ): ZIO[zio.aws.ses.Ses, AwsError, Unit] =
    ZIO.serviceWithZIO(_.verifyEmailAddress(request))
  def getAccountSendingEnabled(): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.GetAccountSendingEnabledResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountSendingEnabled())
  def deleteConfigurationSet(request: DeleteConfigurationSetRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.DeleteConfigurationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConfigurationSet(request))
  def createConfigurationSet(request: CreateConfigurationSetRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.CreateConfigurationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConfigurationSet(request))
  def sendRawEmail(request: SendRawEmailRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.SendRawEmailResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendRawEmail(request))
  def updateAccountSendingEnabled(
      request: UpdateAccountSendingEnabledRequest
  ): ZIO[zio.aws.ses.Ses, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateAccountSendingEnabled(request))
  def listReceiptRuleSets(request: ListReceiptRuleSetsRequest): ZStream[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listReceiptRuleSets(request))
  def listReceiptRuleSetsPaginated(request: ListReceiptRuleSetsRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.ListReceiptRuleSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReceiptRuleSetsPaginated(request))
  def verifyDomainIdentity(request: VerifyDomainIdentityRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.VerifyDomainIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.verifyDomainIdentity(request))
  def createReceiptRule(request: CreateReceiptRuleRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.CreateReceiptRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReceiptRule(request))
  def deleteIdentityPolicy(request: DeleteIdentityPolicyRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.DeleteIdentityPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteIdentityPolicy(request))
  def updateConfigurationSetEventDestination(
      request: UpdateConfigurationSetEventDestinationRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConfigurationSetEventDestination(request))
  def getIdentityPolicies(request: GetIdentityPoliciesRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.GetIdentityPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIdentityPolicies(request))
  def updateConfigurationSetReputationMetricsEnabled(
      request: UpdateConfigurationSetReputationMetricsEnabledRequest
  ): ZIO[zio.aws.ses.Ses, AwsError, Unit] = ZIO.serviceWithZIO(
    _.updateConfigurationSetReputationMetricsEnabled(request)
  )
  def setIdentityMailFromDomain(request: SetIdentityMailFromDomainRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.SetIdentityMailFromDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setIdentityMailFromDomain(request))
  def getCustomVerificationEmailTemplate(
      request: GetCustomVerificationEmailTemplateRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.GetCustomVerificationEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCustomVerificationEmailTemplate(request))
  def sendCustomVerificationEmail(
      request: SendCustomVerificationEmailRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.SendCustomVerificationEmailResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendCustomVerificationEmail(request))
  def sendBounce(request: SendBounceRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.SendBounceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendBounce(request))
  def getSendQuota(): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.GetSendQuotaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSendQuota())
  def putConfigurationSetDeliveryOptions(
      request: PutConfigurationSetDeliveryOptionsRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConfigurationSetDeliveryOptions(request))
  def getTemplate(request: GetTemplateRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.GetTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTemplate(request))
  def setReceiptRulePosition(request: SetReceiptRulePositionRequest): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.SetReceiptRulePositionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setReceiptRulePosition(request))
  def deleteConfigurationSetEventDestination(
      request: DeleteConfigurationSetEventDestinationRequest
  ): ZIO[
    zio.aws.ses.Ses,
    AwsError,
    zio.aws.ses.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConfigurationSetEventDestination(request))
}
