package zio.aws.ses
import zio.aws.ses.model.GetIdentityMailFromDomainAttributesResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.ses.model.{
  ListReceiptRuleSetsRequest,
  ListIdentityPoliciesRequest,
  DeleteVerifiedEmailAddressRequest,
  TestRenderTemplateRequest,
  SetIdentityHeadersInNotificationsEnabledRequest,
  ReorderReceiptRuleSetRequest,
  CreateReceiptRuleSetRequest,
  CreateConfigurationSetTrackingOptionsRequest,
  VerifyDomainIdentityRequest,
  DescribeActiveReceiptRuleSetRequest,
  ListIdentitiesRequest,
  VerifyEmailIdentityRequest,
  SetReceiptRulePositionRequest,
  GetIdentityMailFromDomainAttributesRequest,
  DeleteConfigurationSetRequest,
  SetIdentityFeedbackForwardingEnabledRequest,
  UpdateConfigurationSetEventDestinationRequest,
  DeleteCustomVerificationEmailTemplateRequest,
  DeleteReceiptFilterRequest,
  SetActiveReceiptRuleSetRequest,
  GetIdentityDkimAttributesRequest,
  DescribeConfigurationSetRequest,
  DeleteTemplateRequest,
  DeleteReceiptRuleRequest,
  UpdateAccountSendingEnabledRequest,
  VerifyEmailAddressRequest,
  ListReceiptFiltersRequest,
  GetIdentityPoliciesRequest,
  CreateReceiptFilterRequest,
  CreateConfigurationSetRequest,
  PutIdentityPolicyRequest,
  SendTemplatedEmailRequest,
  UpdateReceiptRuleRequest,
  UpdateConfigurationSetReputationMetricsEnabledRequest,
  DeleteReceiptRuleSetRequest,
  SetIdentityMailFromDomainRequest,
  GetIdentityVerificationAttributesRequest,
  SendEmailRequest,
  CreateReceiptRuleRequest,
  PutConfigurationSetDeliveryOptionsRequest,
  ListConfigurationSetsRequest,
  CloneReceiptRuleSetRequest,
  UpdateCustomVerificationEmailTemplateRequest,
  DeleteIdentityRequest,
  SendRawEmailRequest,
  DescribeReceiptRuleSetRequest,
  CreateConfigurationSetEventDestinationRequest,
  UpdateConfigurationSetTrackingOptionsRequest,
  ListCustomVerificationEmailTemplatesRequest,
  SetIdentityDkimEnabledRequest,
  DeleteConfigurationSetEventDestinationRequest,
  UpdateTemplateRequest,
  UpdateConfigurationSetSendingEnabledRequest,
  DeleteIdentityPolicyRequest,
  VerifyDomainDkimRequest,
  ListTemplatesRequest,
  DeleteConfigurationSetTrackingOptionsRequest,
  SendCustomVerificationEmailRequest,
  GetTemplateRequest,
  DescribeReceiptRuleRequest,
  SendBulkTemplatedEmailRequest,
  SetIdentityNotificationTopicRequest,
  CreateCustomVerificationEmailTemplateRequest,
  CreateTemplateRequest,
  GetIdentityNotificationAttributesRequest,
  GetCustomVerificationEmailTemplateRequest,
  SendBounceRequest
}
import zio.aws.ses.model.primitives.Identity
import software.amazon.awssdk.services.ses.SesAsyncClient
import zio.stream.ZStream
object SesMock extends Mock[Ses] {
  object DeleteConfigurationSetTrackingOptions
      extends Effect[
        DeleteConfigurationSetTrackingOptionsRequest,
        AwsError,
        zio.aws.ses.model.DeleteConfigurationSetTrackingOptionsResponse.ReadOnly
      ]
  object DeleteReceiptRule
      extends Effect[
        DeleteReceiptRuleRequest,
        AwsError,
        zio.aws.ses.model.DeleteReceiptRuleResponse.ReadOnly
      ]
  object CreateReceiptFilter
      extends Effect[
        CreateReceiptFilterRequest,
        AwsError,
        zio.aws.ses.model.CreateReceiptFilterResponse.ReadOnly
      ]
  object CreateConfigurationSetEventDestination
      extends Effect[
        CreateConfigurationSetEventDestinationRequest,
        AwsError,
        zio.aws.ses.model.CreateConfigurationSetEventDestinationResponse.ReadOnly
      ]
  object GetIdentityDkimAttributes
      extends Effect[
        GetIdentityDkimAttributesRequest,
        AwsError,
        zio.aws.ses.model.GetIdentityDkimAttributesResponse.ReadOnly
      ]
  object SetIdentityFeedbackForwardingEnabled
      extends Effect[
        SetIdentityFeedbackForwardingEnabledRequest,
        AwsError,
        zio.aws.ses.model.SetIdentityFeedbackForwardingEnabledResponse.ReadOnly
      ]
  object UpdateTemplate
      extends Effect[
        UpdateTemplateRequest,
        AwsError,
        zio.aws.ses.model.UpdateTemplateResponse.ReadOnly
      ]
  object ListIdentityPolicies
      extends Effect[
        ListIdentityPoliciesRequest,
        AwsError,
        zio.aws.ses.model.ListIdentityPoliciesResponse.ReadOnly
      ]
  object ListIdentities
      extends Stream[ListIdentitiesRequest, AwsError, Identity]
  object ListIdentitiesPaginated
      extends Effect[
        ListIdentitiesRequest,
        AwsError,
        zio.aws.ses.model.ListIdentitiesResponse.ReadOnly
      ]
  object SetIdentityNotificationTopic
      extends Effect[
        SetIdentityNotificationTopicRequest,
        AwsError,
        zio.aws.ses.model.SetIdentityNotificationTopicResponse.ReadOnly
      ]
  object SendEmail
      extends Effect[
        SendEmailRequest,
        AwsError,
        zio.aws.ses.model.SendEmailResponse.ReadOnly
      ]
  object CreateCustomVerificationEmailTemplate
      extends Effect[
        CreateCustomVerificationEmailTemplateRequest,
        AwsError,
        Unit
      ]
  object TestRenderTemplate
      extends Effect[
        TestRenderTemplateRequest,
        AwsError,
        zio.aws.ses.model.TestRenderTemplateResponse.ReadOnly
      ]
  object CreateReceiptRuleSet
      extends Effect[
        CreateReceiptRuleSetRequest,
        AwsError,
        zio.aws.ses.model.CreateReceiptRuleSetResponse.ReadOnly
      ]
  object CreateTemplate
      extends Effect[
        CreateTemplateRequest,
        AwsError,
        zio.aws.ses.model.CreateTemplateResponse.ReadOnly
      ]
  object DescribeConfigurationSet
      extends Effect[
        DescribeConfigurationSetRequest,
        AwsError,
        zio.aws.ses.model.DescribeConfigurationSetResponse.ReadOnly
      ]
  object DeleteIdentity
      extends Effect[
        DeleteIdentityRequest,
        AwsError,
        zio.aws.ses.model.DeleteIdentityResponse.ReadOnly
      ]
  object DeleteTemplate
      extends Effect[
        DeleteTemplateRequest,
        AwsError,
        zio.aws.ses.model.DeleteTemplateResponse.ReadOnly
      ]
  object PutIdentityPolicy
      extends Effect[
        PutIdentityPolicyRequest,
        AwsError,
        zio.aws.ses.model.PutIdentityPolicyResponse.ReadOnly
      ]
  object UpdateConfigurationSetTrackingOptions
      extends Effect[
        UpdateConfigurationSetTrackingOptionsRequest,
        AwsError,
        zio.aws.ses.model.UpdateConfigurationSetTrackingOptionsResponse.ReadOnly
      ]
  object SendBulkTemplatedEmail
      extends Effect[
        SendBulkTemplatedEmailRequest,
        AwsError,
        zio.aws.ses.model.SendBulkTemplatedEmailResponse.ReadOnly
      ]
  object SetIdentityHeadersInNotificationsEnabled
      extends Effect[
        SetIdentityHeadersInNotificationsEnabledRequest,
        AwsError,
        zio.aws.ses.model.SetIdentityHeadersInNotificationsEnabledResponse.ReadOnly
      ]
  object DescribeReceiptRule
      extends Effect[
        DescribeReceiptRuleRequest,
        AwsError,
        zio.aws.ses.model.DescribeReceiptRuleResponse.ReadOnly
      ]
  object SendTemplatedEmail
      extends Effect[
        SendTemplatedEmailRequest,
        AwsError,
        zio.aws.ses.model.SendTemplatedEmailResponse.ReadOnly
      ]
  object SetIdentityDkimEnabled
      extends Effect[
        SetIdentityDkimEnabledRequest,
        AwsError,
        zio.aws.ses.model.SetIdentityDkimEnabledResponse.ReadOnly
      ]
  object ListTemplates
      extends Stream[
        ListTemplatesRequest,
        AwsError,
        zio.aws.ses.model.TemplateMetadata.ReadOnly
      ]
  object ListTemplatesPaginated
      extends Effect[
        ListTemplatesRequest,
        AwsError,
        zio.aws.ses.model.ListTemplatesResponse.ReadOnly
      ]
  object GetSendStatistics
      extends Effect[
        Unit,
        AwsError,
        zio.aws.ses.model.GetSendStatisticsResponse.ReadOnly
      ]
  object DeleteVerifiedEmailAddress
      extends Effect[DeleteVerifiedEmailAddressRequest, AwsError, Unit]
  object VerifyDomainDkim
      extends Effect[
        VerifyDomainDkimRequest,
        AwsError,
        zio.aws.ses.model.VerifyDomainDkimResponse.ReadOnly
      ]
  object GetIdentityVerificationAttributes
      extends Effect[
        GetIdentityVerificationAttributesRequest,
        AwsError,
        zio.aws.ses.model.GetIdentityVerificationAttributesResponse.ReadOnly
      ]
  object DescribeReceiptRuleSet
      extends Effect[
        DescribeReceiptRuleSetRequest,
        AwsError,
        zio.aws.ses.model.DescribeReceiptRuleSetResponse.ReadOnly
      ]
  object GetIdentityMailFromDomainAttributes
      extends Effect[
        GetIdentityMailFromDomainAttributesRequest,
        AwsError,
        ReadOnly
      ]
  object ListCustomVerificationEmailTemplates
      extends Stream[
        ListCustomVerificationEmailTemplatesRequest,
        AwsError,
        zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly
      ]
  object ListCustomVerificationEmailTemplatesPaginated
      extends Effect[
        ListCustomVerificationEmailTemplatesRequest,
        AwsError,
        zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly
      ]
  object CloneReceiptRuleSet
      extends Effect[
        CloneReceiptRuleSetRequest,
        AwsError,
        zio.aws.ses.model.CloneReceiptRuleSetResponse.ReadOnly
      ]
  object ListReceiptFilters
      extends Effect[
        ListReceiptFiltersRequest,
        AwsError,
        zio.aws.ses.model.ListReceiptFiltersResponse.ReadOnly
      ]
  object DescribeActiveReceiptRuleSet
      extends Effect[
        DescribeActiveReceiptRuleSetRequest,
        AwsError,
        zio.aws.ses.model.DescribeActiveReceiptRuleSetResponse.ReadOnly
      ]
  object DeleteReceiptRuleSet
      extends Effect[
        DeleteReceiptRuleSetRequest,
        AwsError,
        zio.aws.ses.model.DeleteReceiptRuleSetResponse.ReadOnly
      ]
  object SetActiveReceiptRuleSet
      extends Effect[
        SetActiveReceiptRuleSetRequest,
        AwsError,
        zio.aws.ses.model.SetActiveReceiptRuleSetResponse.ReadOnly
      ]
  object GetIdentityNotificationAttributes
      extends Effect[
        GetIdentityNotificationAttributesRequest,
        AwsError,
        zio.aws.ses.model.GetIdentityNotificationAttributesResponse.ReadOnly
      ]
  object VerifyEmailIdentity
      extends Effect[
        VerifyEmailIdentityRequest,
        AwsError,
        zio.aws.ses.model.VerifyEmailIdentityResponse.ReadOnly
      ]
  object DeleteReceiptFilter
      extends Effect[
        DeleteReceiptFilterRequest,
        AwsError,
        zio.aws.ses.model.DeleteReceiptFilterResponse.ReadOnly
      ]
  object UpdateCustomVerificationEmailTemplate
      extends Effect[
        UpdateCustomVerificationEmailTemplateRequest,
        AwsError,
        Unit
      ]
  object UpdateReceiptRule
      extends Effect[
        UpdateReceiptRuleRequest,
        AwsError,
        zio.aws.ses.model.UpdateReceiptRuleResponse.ReadOnly
      ]
  object ListConfigurationSets
      extends Stream[
        ListConfigurationSetsRequest,
        AwsError,
        zio.aws.ses.model.ConfigurationSet.ReadOnly
      ]
  object ListConfigurationSetsPaginated
      extends Effect[
        ListConfigurationSetsRequest,
        AwsError,
        zio.aws.ses.model.ListConfigurationSetsResponse.ReadOnly
      ]
  object ReorderReceiptRuleSet
      extends Effect[
        ReorderReceiptRuleSetRequest,
        AwsError,
        zio.aws.ses.model.ReorderReceiptRuleSetResponse.ReadOnly
      ]
  object CreateConfigurationSetTrackingOptions
      extends Effect[
        CreateConfigurationSetTrackingOptionsRequest,
        AwsError,
        zio.aws.ses.model.CreateConfigurationSetTrackingOptionsResponse.ReadOnly
      ]
  object DeleteCustomVerificationEmailTemplate
      extends Effect[
        DeleteCustomVerificationEmailTemplateRequest,
        AwsError,
        Unit
      ]
  object ListVerifiedEmailAddresses
      extends Effect[
        Unit,
        AwsError,
        zio.aws.ses.model.ListVerifiedEmailAddressesResponse.ReadOnly
      ]
  object UpdateConfigurationSetSendingEnabled
      extends Effect[
        UpdateConfigurationSetSendingEnabledRequest,
        AwsError,
        Unit
      ]
  object VerifyEmailAddress
      extends Effect[VerifyEmailAddressRequest, AwsError, Unit]
  object GetAccountSendingEnabled
      extends Effect[
        Unit,
        AwsError,
        zio.aws.ses.model.GetAccountSendingEnabledResponse.ReadOnly
      ]
  object DeleteConfigurationSet
      extends Effect[
        DeleteConfigurationSetRequest,
        AwsError,
        zio.aws.ses.model.DeleteConfigurationSetResponse.ReadOnly
      ]
  object CreateConfigurationSet
      extends Effect[
        CreateConfigurationSetRequest,
        AwsError,
        zio.aws.ses.model.CreateConfigurationSetResponse.ReadOnly
      ]
  object SendRawEmail
      extends Effect[
        SendRawEmailRequest,
        AwsError,
        zio.aws.ses.model.SendRawEmailResponse.ReadOnly
      ]
  object UpdateAccountSendingEnabled
      extends Effect[UpdateAccountSendingEnabledRequest, AwsError, Unit]
  object ListReceiptRuleSets
      extends Stream[
        ListReceiptRuleSetsRequest,
        AwsError,
        zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly
      ]
  object ListReceiptRuleSetsPaginated
      extends Effect[
        ListReceiptRuleSetsRequest,
        AwsError,
        zio.aws.ses.model.ListReceiptRuleSetsResponse.ReadOnly
      ]
  object VerifyDomainIdentity
      extends Effect[
        VerifyDomainIdentityRequest,
        AwsError,
        zio.aws.ses.model.VerifyDomainIdentityResponse.ReadOnly
      ]
  object CreateReceiptRule
      extends Effect[
        CreateReceiptRuleRequest,
        AwsError,
        zio.aws.ses.model.CreateReceiptRuleResponse.ReadOnly
      ]
  object DeleteIdentityPolicy
      extends Effect[
        DeleteIdentityPolicyRequest,
        AwsError,
        zio.aws.ses.model.DeleteIdentityPolicyResponse.ReadOnly
      ]
  object UpdateConfigurationSetEventDestination
      extends Effect[
        UpdateConfigurationSetEventDestinationRequest,
        AwsError,
        zio.aws.ses.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
      ]
  object GetIdentityPolicies
      extends Effect[
        GetIdentityPoliciesRequest,
        AwsError,
        zio.aws.ses.model.GetIdentityPoliciesResponse.ReadOnly
      ]
  object UpdateConfigurationSetReputationMetricsEnabled
      extends Effect[
        UpdateConfigurationSetReputationMetricsEnabledRequest,
        AwsError,
        Unit
      ]
  object SetIdentityMailFromDomain
      extends Effect[
        SetIdentityMailFromDomainRequest,
        AwsError,
        zio.aws.ses.model.SetIdentityMailFromDomainResponse.ReadOnly
      ]
  object GetCustomVerificationEmailTemplate
      extends Effect[
        GetCustomVerificationEmailTemplateRequest,
        AwsError,
        zio.aws.ses.model.GetCustomVerificationEmailTemplateResponse.ReadOnly
      ]
  object SendCustomVerificationEmail
      extends Effect[
        SendCustomVerificationEmailRequest,
        AwsError,
        zio.aws.ses.model.SendCustomVerificationEmailResponse.ReadOnly
      ]
  object SendBounce
      extends Effect[
        SendBounceRequest,
        AwsError,
        zio.aws.ses.model.SendBounceResponse.ReadOnly
      ]
  object GetSendQuota
      extends Effect[
        Unit,
        AwsError,
        zio.aws.ses.model.GetSendQuotaResponse.ReadOnly
      ]
  object PutConfigurationSetDeliveryOptions
      extends Effect[
        PutConfigurationSetDeliveryOptionsRequest,
        AwsError,
        zio.aws.ses.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
      ]
  object GetTemplate
      extends Effect[
        GetTemplateRequest,
        AwsError,
        zio.aws.ses.model.GetTemplateResponse.ReadOnly
      ]
  object SetReceiptRulePosition
      extends Effect[
        SetReceiptRulePositionRequest,
        AwsError,
        zio.aws.ses.model.SetReceiptRulePositionResponse.ReadOnly
      ]
  object DeleteConfigurationSetEventDestination
      extends Effect[
        DeleteConfigurationSetEventDestinationRequest,
        AwsError,
        zio.aws.ses.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Ses] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Ses {
          val api: SesAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Ses = this
          def deleteConfigurationSetTrackingOptions(
              request: DeleteConfigurationSetTrackingOptionsRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.DeleteConfigurationSetTrackingOptionsResponse.ReadOnly
          ] = proxy(DeleteConfigurationSetTrackingOptions, request)
          def deleteReceiptRule(request: DeleteReceiptRuleRequest): IO[
            AwsError,
            zio.aws.ses.model.DeleteReceiptRuleResponse.ReadOnly
          ] = proxy(DeleteReceiptRule, request)
          def createReceiptFilter(request: CreateReceiptFilterRequest): IO[
            AwsError,
            zio.aws.ses.model.CreateReceiptFilterResponse.ReadOnly
          ] = proxy(CreateReceiptFilter, request)
          def createConfigurationSetEventDestination(
              request: CreateConfigurationSetEventDestinationRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.CreateConfigurationSetEventDestinationResponse.ReadOnly
          ] = proxy(CreateConfigurationSetEventDestination, request)
          def getIdentityDkimAttributes(
              request: GetIdentityDkimAttributesRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.GetIdentityDkimAttributesResponse.ReadOnly
          ] = proxy(GetIdentityDkimAttributes, request)
          def setIdentityFeedbackForwardingEnabled(
              request: SetIdentityFeedbackForwardingEnabledRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.SetIdentityFeedbackForwardingEnabledResponse.ReadOnly
          ] = proxy(SetIdentityFeedbackForwardingEnabled, request)
          def updateTemplate(
              request: UpdateTemplateRequest
          ): IO[AwsError, zio.aws.ses.model.UpdateTemplateResponse.ReadOnly] =
            proxy(UpdateTemplate, request)
          def listIdentityPolicies(request: ListIdentityPoliciesRequest): IO[
            AwsError,
            zio.aws.ses.model.ListIdentityPoliciesResponse.ReadOnly
          ] = proxy(ListIdentityPolicies, request)
          def listIdentities(
              request: ListIdentitiesRequest
          ): ZStream[Any, AwsError, Identity] =
            rts.unsafeRun(proxy(ListIdentities, request))
          def listIdentitiesPaginated(
              request: ListIdentitiesRequest
          ): IO[AwsError, zio.aws.ses.model.ListIdentitiesResponse.ReadOnly] =
            proxy(ListIdentitiesPaginated, request)
          def setIdentityNotificationTopic(
              request: SetIdentityNotificationTopicRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.SetIdentityNotificationTopicResponse.ReadOnly
          ] = proxy(SetIdentityNotificationTopic, request)
          def sendEmail(
              request: SendEmailRequest
          ): IO[AwsError, zio.aws.ses.model.SendEmailResponse.ReadOnly] =
            proxy(SendEmail, request)
          def createCustomVerificationEmailTemplate(
              request: CreateCustomVerificationEmailTemplateRequest
          ): IO[AwsError, Unit] =
            proxy(CreateCustomVerificationEmailTemplate, request)
          def testRenderTemplate(request: TestRenderTemplateRequest): IO[
            AwsError,
            zio.aws.ses.model.TestRenderTemplateResponse.ReadOnly
          ] = proxy(TestRenderTemplate, request)
          def createReceiptRuleSet(request: CreateReceiptRuleSetRequest): IO[
            AwsError,
            zio.aws.ses.model.CreateReceiptRuleSetResponse.ReadOnly
          ] = proxy(CreateReceiptRuleSet, request)
          def createTemplate(
              request: CreateTemplateRequest
          ): IO[AwsError, zio.aws.ses.model.CreateTemplateResponse.ReadOnly] =
            proxy(CreateTemplate, request)
          def describeConfigurationSet(
              request: DescribeConfigurationSetRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.DescribeConfigurationSetResponse.ReadOnly
          ] = proxy(DescribeConfigurationSet, request)
          def deleteIdentity(
              request: DeleteIdentityRequest
          ): IO[AwsError, zio.aws.ses.model.DeleteIdentityResponse.ReadOnly] =
            proxy(DeleteIdentity, request)
          def deleteTemplate(
              request: DeleteTemplateRequest
          ): IO[AwsError, zio.aws.ses.model.DeleteTemplateResponse.ReadOnly] =
            proxy(DeleteTemplate, request)
          def putIdentityPolicy(request: PutIdentityPolicyRequest): IO[
            AwsError,
            zio.aws.ses.model.PutIdentityPolicyResponse.ReadOnly
          ] = proxy(PutIdentityPolicy, request)
          def updateConfigurationSetTrackingOptions(
              request: UpdateConfigurationSetTrackingOptionsRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.UpdateConfigurationSetTrackingOptionsResponse.ReadOnly
          ] = proxy(UpdateConfigurationSetTrackingOptions, request)
          def sendBulkTemplatedEmail(
              request: SendBulkTemplatedEmailRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.SendBulkTemplatedEmailResponse.ReadOnly
          ] = proxy(SendBulkTemplatedEmail, request)
          def setIdentityHeadersInNotificationsEnabled(
              request: SetIdentityHeadersInNotificationsEnabledRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.SetIdentityHeadersInNotificationsEnabledResponse.ReadOnly
          ] = proxy(SetIdentityHeadersInNotificationsEnabled, request)
          def describeReceiptRule(request: DescribeReceiptRuleRequest): IO[
            AwsError,
            zio.aws.ses.model.DescribeReceiptRuleResponse.ReadOnly
          ] = proxy(DescribeReceiptRule, request)
          def sendTemplatedEmail(request: SendTemplatedEmailRequest): IO[
            AwsError,
            zio.aws.ses.model.SendTemplatedEmailResponse.ReadOnly
          ] = proxy(SendTemplatedEmail, request)
          def setIdentityDkimEnabled(
              request: SetIdentityDkimEnabledRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.SetIdentityDkimEnabledResponse.ReadOnly
          ] = proxy(SetIdentityDkimEnabled, request)
          def listTemplates(request: ListTemplatesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.ses.model.TemplateMetadata.ReadOnly
          ] = rts.unsafeRun(proxy(ListTemplates, request))
          def listTemplatesPaginated(
              request: ListTemplatesRequest
          ): IO[AwsError, zio.aws.ses.model.ListTemplatesResponse.ReadOnly] =
            proxy(ListTemplatesPaginated, request)
          def getSendStatistics(): IO[
            AwsError,
            zio.aws.ses.model.GetSendStatisticsResponse.ReadOnly
          ] = proxy(GetSendStatistics)
          def deleteVerifiedEmailAddress(
              request: DeleteVerifiedEmailAddressRequest
          ): IO[AwsError, Unit] = proxy(DeleteVerifiedEmailAddress, request)
          def verifyDomainDkim(
              request: VerifyDomainDkimRequest
          ): IO[AwsError, zio.aws.ses.model.VerifyDomainDkimResponse.ReadOnly] =
            proxy(VerifyDomainDkim, request)
          def getIdentityVerificationAttributes(
              request: GetIdentityVerificationAttributesRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.GetIdentityVerificationAttributesResponse.ReadOnly
          ] = proxy(GetIdentityVerificationAttributes, request)
          def describeReceiptRuleSet(
              request: DescribeReceiptRuleSetRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.DescribeReceiptRuleSetResponse.ReadOnly
          ] = proxy(DescribeReceiptRuleSet, request)
          def getIdentityMailFromDomainAttributes(
              request: GetIdentityMailFromDomainAttributesRequest
          ): IO[AwsError, ReadOnly] =
            proxy(GetIdentityMailFromDomainAttributes, request)
          def listCustomVerificationEmailTemplates(
              request: ListCustomVerificationEmailTemplatesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly
          ] =
            rts.unsafeRun(proxy(ListCustomVerificationEmailTemplates, request))
          def listCustomVerificationEmailTemplatesPaginated(
              request: ListCustomVerificationEmailTemplatesRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly
          ] = proxy(ListCustomVerificationEmailTemplatesPaginated, request)
          def cloneReceiptRuleSet(request: CloneReceiptRuleSetRequest): IO[
            AwsError,
            zio.aws.ses.model.CloneReceiptRuleSetResponse.ReadOnly
          ] = proxy(CloneReceiptRuleSet, request)
          def listReceiptFilters(request: ListReceiptFiltersRequest): IO[
            AwsError,
            zio.aws.ses.model.ListReceiptFiltersResponse.ReadOnly
          ] = proxy(ListReceiptFilters, request)
          def describeActiveReceiptRuleSet(
              request: DescribeActiveReceiptRuleSetRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.DescribeActiveReceiptRuleSetResponse.ReadOnly
          ] = proxy(DescribeActiveReceiptRuleSet, request)
          def deleteReceiptRuleSet(request: DeleteReceiptRuleSetRequest): IO[
            AwsError,
            zio.aws.ses.model.DeleteReceiptRuleSetResponse.ReadOnly
          ] = proxy(DeleteReceiptRuleSet, request)
          def setActiveReceiptRuleSet(
              request: SetActiveReceiptRuleSetRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.SetActiveReceiptRuleSetResponse.ReadOnly
          ] = proxy(SetActiveReceiptRuleSet, request)
          def getIdentityNotificationAttributes(
              request: GetIdentityNotificationAttributesRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.GetIdentityNotificationAttributesResponse.ReadOnly
          ] = proxy(GetIdentityNotificationAttributes, request)
          def verifyEmailIdentity(request: VerifyEmailIdentityRequest): IO[
            AwsError,
            zio.aws.ses.model.VerifyEmailIdentityResponse.ReadOnly
          ] = proxy(VerifyEmailIdentity, request)
          def deleteReceiptFilter(request: DeleteReceiptFilterRequest): IO[
            AwsError,
            zio.aws.ses.model.DeleteReceiptFilterResponse.ReadOnly
          ] = proxy(DeleteReceiptFilter, request)
          def updateCustomVerificationEmailTemplate(
              request: UpdateCustomVerificationEmailTemplateRequest
          ): IO[AwsError, Unit] =
            proxy(UpdateCustomVerificationEmailTemplate, request)
          def updateReceiptRule(request: UpdateReceiptRuleRequest): IO[
            AwsError,
            zio.aws.ses.model.UpdateReceiptRuleResponse.ReadOnly
          ] = proxy(UpdateReceiptRule, request)
          def listConfigurationSets(
              request: ListConfigurationSetsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.ses.model.ConfigurationSet.ReadOnly
          ] = rts.unsafeRun(proxy(ListConfigurationSets, request))
          def listConfigurationSetsPaginated(
              request: ListConfigurationSetsRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.ListConfigurationSetsResponse.ReadOnly
          ] = proxy(ListConfigurationSetsPaginated, request)
          def reorderReceiptRuleSet(request: ReorderReceiptRuleSetRequest): IO[
            AwsError,
            zio.aws.ses.model.ReorderReceiptRuleSetResponse.ReadOnly
          ] = proxy(ReorderReceiptRuleSet, request)
          def createConfigurationSetTrackingOptions(
              request: CreateConfigurationSetTrackingOptionsRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.CreateConfigurationSetTrackingOptionsResponse.ReadOnly
          ] = proxy(CreateConfigurationSetTrackingOptions, request)
          def deleteCustomVerificationEmailTemplate(
              request: DeleteCustomVerificationEmailTemplateRequest
          ): IO[AwsError, Unit] =
            proxy(DeleteCustomVerificationEmailTemplate, request)
          def listVerifiedEmailAddresses(): IO[
            AwsError,
            zio.aws.ses.model.ListVerifiedEmailAddressesResponse.ReadOnly
          ] = proxy(ListVerifiedEmailAddresses)
          def updateConfigurationSetSendingEnabled(
              request: UpdateConfigurationSetSendingEnabledRequest
          ): IO[AwsError, Unit] =
            proxy(UpdateConfigurationSetSendingEnabled, request)
          def verifyEmailAddress(
              request: VerifyEmailAddressRequest
          ): IO[AwsError, Unit] = proxy(VerifyEmailAddress, request)
          def getAccountSendingEnabled(): IO[
            AwsError,
            zio.aws.ses.model.GetAccountSendingEnabledResponse.ReadOnly
          ] = proxy(GetAccountSendingEnabled)
          def deleteConfigurationSet(
              request: DeleteConfigurationSetRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.DeleteConfigurationSetResponse.ReadOnly
          ] = proxy(DeleteConfigurationSet, request)
          def createConfigurationSet(
              request: CreateConfigurationSetRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.CreateConfigurationSetResponse.ReadOnly
          ] = proxy(CreateConfigurationSet, request)
          def sendRawEmail(
              request: SendRawEmailRequest
          ): IO[AwsError, zio.aws.ses.model.SendRawEmailResponse.ReadOnly] =
            proxy(SendRawEmail, request)
          def updateAccountSendingEnabled(
              request: UpdateAccountSendingEnabledRequest
          ): IO[AwsError, Unit] = proxy(UpdateAccountSendingEnabled, request)
          def listReceiptRuleSets(request: ListReceiptRuleSetsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly
          ] = rts.unsafeRun(proxy(ListReceiptRuleSets, request))
          def listReceiptRuleSetsPaginated(
              request: ListReceiptRuleSetsRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.ListReceiptRuleSetsResponse.ReadOnly
          ] = proxy(ListReceiptRuleSetsPaginated, request)
          def verifyDomainIdentity(request: VerifyDomainIdentityRequest): IO[
            AwsError,
            zio.aws.ses.model.VerifyDomainIdentityResponse.ReadOnly
          ] = proxy(VerifyDomainIdentity, request)
          def createReceiptRule(request: CreateReceiptRuleRequest): IO[
            AwsError,
            zio.aws.ses.model.CreateReceiptRuleResponse.ReadOnly
          ] = proxy(CreateReceiptRule, request)
          def deleteIdentityPolicy(request: DeleteIdentityPolicyRequest): IO[
            AwsError,
            zio.aws.ses.model.DeleteIdentityPolicyResponse.ReadOnly
          ] = proxy(DeleteIdentityPolicy, request)
          def updateConfigurationSetEventDestination(
              request: UpdateConfigurationSetEventDestinationRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
          ] = proxy(UpdateConfigurationSetEventDestination, request)
          def getIdentityPolicies(request: GetIdentityPoliciesRequest): IO[
            AwsError,
            zio.aws.ses.model.GetIdentityPoliciesResponse.ReadOnly
          ] = proxy(GetIdentityPolicies, request)
          def updateConfigurationSetReputationMetricsEnabled(
              request: UpdateConfigurationSetReputationMetricsEnabledRequest
          ): IO[AwsError, Unit] =
            proxy(UpdateConfigurationSetReputationMetricsEnabled, request)
          def setIdentityMailFromDomain(
              request: SetIdentityMailFromDomainRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.SetIdentityMailFromDomainResponse.ReadOnly
          ] = proxy(SetIdentityMailFromDomain, request)
          def getCustomVerificationEmailTemplate(
              request: GetCustomVerificationEmailTemplateRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.GetCustomVerificationEmailTemplateResponse.ReadOnly
          ] = proxy(GetCustomVerificationEmailTemplate, request)
          def sendCustomVerificationEmail(
              request: SendCustomVerificationEmailRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.SendCustomVerificationEmailResponse.ReadOnly
          ] = proxy(SendCustomVerificationEmail, request)
          def sendBounce(
              request: SendBounceRequest
          ): IO[AwsError, zio.aws.ses.model.SendBounceResponse.ReadOnly] =
            proxy(SendBounce, request)
          def getSendQuota()
              : IO[AwsError, zio.aws.ses.model.GetSendQuotaResponse.ReadOnly] =
            proxy(GetSendQuota)
          def putConfigurationSetDeliveryOptions(
              request: PutConfigurationSetDeliveryOptionsRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
          ] = proxy(PutConfigurationSetDeliveryOptions, request)
          def getTemplate(
              request: GetTemplateRequest
          ): IO[AwsError, zio.aws.ses.model.GetTemplateResponse.ReadOnly] =
            proxy(GetTemplate, request)
          def setReceiptRulePosition(
              request: SetReceiptRulePositionRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.SetReceiptRulePositionResponse.ReadOnly
          ] = proxy(SetReceiptRulePosition, request)
          def deleteConfigurationSetEventDestination(
              request: DeleteConfigurationSetEventDestinationRequest
          ): IO[
            AwsError,
            zio.aws.ses.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
          ] = proxy(DeleteConfigurationSetEventDestination, request)
        }
      }
    }
  }
}
