package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  BounceSmtpReplyCode,
  AmazonResourceName,
  BounceMessage,
  Address,
  BounceStatusCode
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BounceAction(
    topicArn: Optional[AmazonResourceName] = Optional.Absent,
    smtpReplyCode: BounceSmtpReplyCode,
    statusCode: Optional[BounceStatusCode] = Optional.Absent,
    message: BounceMessage,
    sender: Address
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.BounceAction = {
    import BounceAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.BounceAction
      .builder()
      .optionallyWith(
        topicArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.topicArn)
      .smtpReplyCode(
        BounceSmtpReplyCode.unwrap(smtpReplyCode): java.lang.String
      )
      .optionallyWith(
        statusCode.map(value =>
          BounceStatusCode.unwrap(value): java.lang.String
        )
      )(_.statusCode)
      .message(BounceMessage.unwrap(message): java.lang.String)
      .sender(Address.unwrap(sender): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.BounceAction.ReadOnly =
    zio.aws.ses.model.BounceAction.wrap(buildAwsValue())
}
object BounceAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.BounceAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.BounceAction =
      zio.aws.ses.model.BounceAction(
        topicArn.map(value => value),
        smtpReplyCode,
        statusCode.map(value => value),
        message,
        sender
      )
    def topicArn: Optional[AmazonResourceName]
    def smtpReplyCode: BounceSmtpReplyCode
    def statusCode: Optional[BounceStatusCode]
    def message: BounceMessage
    def sender: Address
    def getTopicArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("topicArn", topicArn)
    def getSmtpReplyCode: ZIO[Any, Nothing, BounceSmtpReplyCode] =
      ZIO.succeed(smtpReplyCode)
    def getStatusCode: ZIO[Any, AwsError, BounceStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getMessage: ZIO[Any, Nothing, BounceMessage] = ZIO.succeed(message)
    def getSender: ZIO[Any, Nothing, Address] = ZIO.succeed(sender)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.BounceAction
  ) extends zio.aws.ses.model.BounceAction.ReadOnly {
    override val topicArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.topicArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val smtpReplyCode: BounceSmtpReplyCode =
      zio.aws.ses.model.primitives.BounceSmtpReplyCode(impl.smtpReplyCode())
    override val statusCode: Optional[BounceStatusCode] = zio.aws.core.internal
      .optionalFromNullable(impl.statusCode())
      .map(value => zio.aws.ses.model.primitives.BounceStatusCode(value))
    override val message: BounceMessage =
      zio.aws.ses.model.primitives.BounceMessage(impl.message())
    override val sender: Address =
      zio.aws.ses.model.primitives.Address(impl.sender())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.BounceAction
  ): zio.aws.ses.model.BounceAction.ReadOnly = new Wrapper(impl)
}
