package zio.aws.ses.model
import scala.jdk.CollectionConverters._
sealed trait BounceType {
  def unwrap: software.amazon.awssdk.services.ses.model.BounceType
}
object BounceType {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.BounceType
  ): zio.aws.ses.model.BounceType = value match {
    case software.amazon.awssdk.services.ses.model.BounceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.BounceType.DOES_NOT_EXIST =>
      val r = DoesNotExist
      r
    case software.amazon.awssdk.services.ses.model.BounceType.MESSAGE_TOO_LARGE =>
      val r = MessageTooLarge
      r
    case software.amazon.awssdk.services.ses.model.BounceType.EXCEEDED_QUOTA =>
      val r = ExceededQuota
      r
    case software.amazon.awssdk.services.ses.model.BounceType.CONTENT_REJECTED =>
      val r = ContentRejected
      r
    case software.amazon.awssdk.services.ses.model.BounceType.UNDEFINED =>
      val r = Undefined
      r
    case software.amazon.awssdk.services.ses.model.BounceType.TEMPORARY_FAILURE =>
      val r = TemporaryFailure
      r
  }
  case object unknownToSdkVersion extends zio.aws.ses.model.BounceType {
    override def unwrap: software.amazon.awssdk.services.ses.model.BounceType =
      software.amazon.awssdk.services.ses.model.BounceType.UNKNOWN_TO_SDK_VERSION
  }
  case object DoesNotExist extends zio.aws.ses.model.BounceType {
    override def unwrap: software.amazon.awssdk.services.ses.model.BounceType =
      software.amazon.awssdk.services.ses.model.BounceType.DOES_NOT_EXIST
  }
  case object MessageTooLarge extends zio.aws.ses.model.BounceType {
    override def unwrap: software.amazon.awssdk.services.ses.model.BounceType =
      software.amazon.awssdk.services.ses.model.BounceType.MESSAGE_TOO_LARGE
  }
  case object ExceededQuota extends zio.aws.ses.model.BounceType {
    override def unwrap: software.amazon.awssdk.services.ses.model.BounceType =
      software.amazon.awssdk.services.ses.model.BounceType.EXCEEDED_QUOTA
  }
  case object ContentRejected extends zio.aws.ses.model.BounceType {
    override def unwrap: software.amazon.awssdk.services.ses.model.BounceType =
      software.amazon.awssdk.services.ses.model.BounceType.CONTENT_REJECTED
  }
  case object Undefined extends zio.aws.ses.model.BounceType {
    override def unwrap: software.amazon.awssdk.services.ses.model.BounceType =
      software.amazon.awssdk.services.ses.model.BounceType.UNDEFINED
  }
  case object TemporaryFailure extends zio.aws.ses.model.BounceType {
    override def unwrap: software.amazon.awssdk.services.ses.model.BounceType =
      software.amazon.awssdk.services.ses.model.BounceType.TEMPORARY_FAILURE
  }
}
