package zio.aws.ses.model
import zio.aws.ses.model.primitives.ReceiptRuleSetName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CloneReceiptRuleSetRequest(
    ruleSetName: ReceiptRuleSetName,
    originalRuleSetName: ReceiptRuleSetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetRequest = {
    import CloneReceiptRuleSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetRequest
      .builder()
      .ruleSetName(ReceiptRuleSetName.unwrap(ruleSetName): java.lang.String)
      .originalRuleSetName(
        ReceiptRuleSetName.unwrap(originalRuleSetName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.CloneReceiptRuleSetRequest.ReadOnly =
    zio.aws.ses.model.CloneReceiptRuleSetRequest.wrap(buildAwsValue())
}
object CloneReceiptRuleSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.CloneReceiptRuleSetRequest =
      zio.aws.ses.model
        .CloneReceiptRuleSetRequest(ruleSetName, originalRuleSetName)
    def ruleSetName: ReceiptRuleSetName
    def originalRuleSetName: ReceiptRuleSetName
    def getRuleSetName: ZIO[Any, Nothing, ReceiptRuleSetName] =
      ZIO.succeed(ruleSetName)
    def getOriginalRuleSetName: ZIO[Any, Nothing, ReceiptRuleSetName] =
      ZIO.succeed(originalRuleSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetRequest
  ) extends zio.aws.ses.model.CloneReceiptRuleSetRequest.ReadOnly {
    override val ruleSetName: ReceiptRuleSetName =
      zio.aws.ses.model.primitives.ReceiptRuleSetName(impl.ruleSetName())
    override val originalRuleSetName: ReceiptRuleSetName =
      zio.aws.ses.model.primitives
        .ReceiptRuleSetName(impl.originalRuleSetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetRequest
  ): zio.aws.ses.model.CloneReceiptRuleSetRequest.ReadOnly = new Wrapper(impl)
}
