package zio.aws.ses.model
import scala.jdk.CollectionConverters._
sealed trait ConfigurationSetAttribute {
  def unwrap
      : software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute
}
object ConfigurationSetAttribute {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute
  ): zio.aws.ses.model.ConfigurationSetAttribute = value match {
    case software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute.EVENT_DESTINATIONS =>
      val r = eventDestinations
      r
    case software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute.TRACKING_OPTIONS =>
      val r = trackingOptions
      r
    case software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute.DELIVERY_OPTIONS =>
      val r = deliveryOptions
      r
    case software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute.REPUTATION_OPTIONS =>
      val r = reputationOptions
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ses.model.ConfigurationSetAttribute {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute =
      software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute.UNKNOWN_TO_SDK_VERSION
  }
  case object eventDestinations
      extends zio.aws.ses.model.ConfigurationSetAttribute {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute =
      software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute.EVENT_DESTINATIONS
  }
  case object trackingOptions
      extends zio.aws.ses.model.ConfigurationSetAttribute {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute =
      software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute.TRACKING_OPTIONS
  }
  case object deliveryOptions
      extends zio.aws.ses.model.ConfigurationSetAttribute {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute =
      software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute.DELIVERY_OPTIONS
  }
  case object reputationOptions
      extends zio.aws.ses.model.ConfigurationSetAttribute {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute =
      software.amazon.awssdk.services.ses.model.ConfigurationSetAttribute.REPUTATION_OPTIONS
  }
}
