package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateReceiptFilterRequest(
    filter: zio.aws.ses.model.ReceiptFilter
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.CreateReceiptFilterRequest = {
    import CreateReceiptFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.CreateReceiptFilterRequest
      .builder()
      .filter(filter.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ses.model.CreateReceiptFilterRequest.ReadOnly =
    zio.aws.ses.model.CreateReceiptFilterRequest.wrap(buildAwsValue())
}
object CreateReceiptFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.CreateReceiptFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.CreateReceiptFilterRequest =
      zio.aws.ses.model.CreateReceiptFilterRequest(filter.asEditable)
    def filter: zio.aws.ses.model.ReceiptFilter.ReadOnly
    def getFilter: ZIO[Any, Nothing, zio.aws.ses.model.ReceiptFilter.ReadOnly] =
      ZIO.succeed(filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.CreateReceiptFilterRequest
  ) extends zio.aws.ses.model.CreateReceiptFilterRequest.ReadOnly {
    override val filter: zio.aws.ses.model.ReceiptFilter.ReadOnly =
      zio.aws.ses.model.ReceiptFilter.wrap(impl.filter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.CreateReceiptFilterRequest
  ): zio.aws.ses.model.CreateReceiptFilterRequest.ReadOnly = new Wrapper(impl)
}
