package zio.aws.ses.model
import scala.jdk.CollectionConverters._
sealed trait CustomMailFromStatus {
  def unwrap: software.amazon.awssdk.services.ses.model.CustomMailFromStatus
}
object CustomMailFromStatus {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.CustomMailFromStatus
  ): zio.aws.ses.model.CustomMailFromStatus = value match {
    case software.amazon.awssdk.services.ses.model.CustomMailFromStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.CustomMailFromStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.ses.model.CustomMailFromStatus.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.ses.model.CustomMailFromStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.ses.model.CustomMailFromStatus.TEMPORARY_FAILURE =>
      val r = TemporaryFailure
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ses.model.CustomMailFromStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.CustomMailFromStatus =
      software.amazon.awssdk.services.ses.model.CustomMailFromStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.ses.model.CustomMailFromStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.CustomMailFromStatus =
      software.amazon.awssdk.services.ses.model.CustomMailFromStatus.PENDING
  }
  case object Success extends zio.aws.ses.model.CustomMailFromStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.CustomMailFromStatus =
      software.amazon.awssdk.services.ses.model.CustomMailFromStatus.SUCCESS
  }
  case object Failed extends zio.aws.ses.model.CustomMailFromStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.CustomMailFromStatus =
      software.amazon.awssdk.services.ses.model.CustomMailFromStatus.FAILED
  }
  case object TemporaryFailure extends zio.aws.ses.model.CustomMailFromStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.CustomMailFromStatus =
      software.amazon.awssdk.services.ses.model.CustomMailFromStatus.TEMPORARY_FAILURE
  }
}
