package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  TemplateName,
  FromAddress,
  FailureRedirectionURL,
  SuccessRedirectionURL,
  Subject
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CustomVerificationEmailTemplate(
    templateName: Optional[TemplateName] = Optional.Absent,
    fromEmailAddress: Optional[FromAddress] = Optional.Absent,
    templateSubject: Optional[Subject] = Optional.Absent,
    successRedirectionURL: Optional[SuccessRedirectionURL] = Optional.Absent,
    failureRedirectionURL: Optional[FailureRedirectionURL] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplate = {
    import CustomVerificationEmailTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplate
      .builder()
      .optionallyWith(
        templateName.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.templateName)
      .optionallyWith(
        fromEmailAddress.map(value =>
          FromAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .optionallyWith(
        templateSubject.map(value => Subject.unwrap(value): java.lang.String)
      )(_.templateSubject)
      .optionallyWith(
        successRedirectionURL.map(value =>
          SuccessRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.successRedirectionURL)
      .optionallyWith(
        failureRedirectionURL.map(value =>
          FailureRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.failureRedirectionURL)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly =
    zio.aws.ses.model.CustomVerificationEmailTemplate.wrap(buildAwsValue())
}
object CustomVerificationEmailTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.CustomVerificationEmailTemplate =
      zio.aws.ses.model.CustomVerificationEmailTemplate(
        templateName.map(value => value),
        fromEmailAddress.map(value => value),
        templateSubject.map(value => value),
        successRedirectionURL.map(value => value),
        failureRedirectionURL.map(value => value)
      )
    def templateName: Optional[TemplateName]
    def fromEmailAddress: Optional[FromAddress]
    def templateSubject: Optional[Subject]
    def successRedirectionURL: Optional[SuccessRedirectionURL]
    def failureRedirectionURL: Optional[FailureRedirectionURL]
    def getTemplateName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getFromEmailAddress: ZIO[Any, AwsError, FromAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getTemplateSubject: ZIO[Any, AwsError, Subject] =
      AwsError.unwrapOptionField("templateSubject", templateSubject)
    def getSuccessRedirectionURL: ZIO[Any, AwsError, SuccessRedirectionURL] =
      AwsError.unwrapOptionField("successRedirectionURL", successRedirectionURL)
    def getFailureRedirectionURL: ZIO[Any, AwsError, FailureRedirectionURL] =
      AwsError.unwrapOptionField("failureRedirectionURL", failureRedirectionURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplate
  ) extends zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly {
    override val templateName: Optional[TemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.templateName())
      .map(value => zio.aws.ses.model.primitives.TemplateName(value))
    override val fromEmailAddress: Optional[FromAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.fromEmailAddress())
      .map(value => zio.aws.ses.model.primitives.FromAddress(value))
    override val templateSubject: Optional[Subject] = zio.aws.core.internal
      .optionalFromNullable(impl.templateSubject())
      .map(value => zio.aws.ses.model.primitives.Subject(value))
    override val successRedirectionURL: Optional[SuccessRedirectionURL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successRedirectionURL())
        .map(value => zio.aws.ses.model.primitives.SuccessRedirectionURL(value))
    override val failureRedirectionURL: Optional[FailureRedirectionURL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureRedirectionURL())
        .map(value => zio.aws.ses.model.primitives.FailureRedirectionURL(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplate
  ): zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly = new Wrapper(
    impl
  )
}
