package zio.aws.ses.model
import zio.aws.ses.model.primitives.TemplateName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCustomVerificationEmailTemplateRequest(
    templateName: TemplateName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateRequest = {
    import DeleteCustomVerificationEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.DeleteCustomVerificationEmailTemplateRequest.ReadOnly =
    zio.aws.ses.model.DeleteCustomVerificationEmailTemplateRequest
      .wrap(buildAwsValue())
}
object DeleteCustomVerificationEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.DeleteCustomVerificationEmailTemplateRequest =
      zio.aws.ses.model
        .DeleteCustomVerificationEmailTemplateRequest(templateName)
    def templateName: TemplateName
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateRequest
  ) extends zio.aws.ses.model.DeleteCustomVerificationEmailTemplateRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.ses.model.primitives.TemplateName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DeleteCustomVerificationEmailTemplateRequest
  ): zio.aws.ses.model.DeleteCustomVerificationEmailTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
