package zio.aws.ses.model
import zio.aws.ses.model.primitives.{ReceiptRuleName, ReceiptRuleSetName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteReceiptRuleRequest(
    ruleSetName: ReceiptRuleSetName,
    ruleName: ReceiptRuleName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DeleteReceiptRuleRequest = {
    import DeleteReceiptRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DeleteReceiptRuleRequest
      .builder()
      .ruleSetName(ReceiptRuleSetName.unwrap(ruleSetName): java.lang.String)
      .ruleName(ReceiptRuleName.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DeleteReceiptRuleRequest.ReadOnly =
    zio.aws.ses.model.DeleteReceiptRuleRequest.wrap(buildAwsValue())
}
object DeleteReceiptRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DeleteReceiptRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DeleteReceiptRuleRequest =
      zio.aws.ses.model.DeleteReceiptRuleRequest(ruleSetName, ruleName)
    def ruleSetName: ReceiptRuleSetName
    def ruleName: ReceiptRuleName
    def getRuleSetName: ZIO[Any, Nothing, ReceiptRuleSetName] =
      ZIO.succeed(ruleSetName)
    def getRuleName: ZIO[Any, Nothing, ReceiptRuleName] = ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DeleteReceiptRuleRequest
  ) extends zio.aws.ses.model.DeleteReceiptRuleRequest.ReadOnly {
    override val ruleSetName: ReceiptRuleSetName =
      zio.aws.ses.model.primitives.ReceiptRuleSetName(impl.ruleSetName())
    override val ruleName: ReceiptRuleName =
      zio.aws.ses.model.primitives.ReceiptRuleName(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DeleteReceiptRuleRequest
  ): zio.aws.ses.model.DeleteReceiptRuleRequest.ReadOnly = new Wrapper(impl)
}
