package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeActiveReceiptRuleSetResponse(
    metadata: Optional[zio.aws.ses.model.ReceiptRuleSetMetadata] =
      Optional.Absent,
    rules: Optional[Iterable[zio.aws.ses.model.ReceiptRule]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetResponse = {
    import DescribeActiveReceiptRuleSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetResponse
      .builder()
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.DescribeActiveReceiptRuleSetResponse.ReadOnly =
    zio.aws.ses.model.DescribeActiveReceiptRuleSetResponse.wrap(buildAwsValue())
}
object DescribeActiveReceiptRuleSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DescribeActiveReceiptRuleSetResponse =
      zio.aws.ses.model.DescribeActiveReceiptRuleSetResponse(
        metadata.map(value => value.asEditable),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metadata: Optional[zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly]
    def rules: Optional[List[zio.aws.ses.model.ReceiptRule.ReadOnly]]
    def getMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("metadata", metadata)
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.ses.model.ReceiptRule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetResponse
  ) extends zio.aws.ses.model.DescribeActiveReceiptRuleSetResponse.ReadOnly {
    override val metadata
        : Optional[zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value => zio.aws.ses.model.ReceiptRuleSetMetadata.wrap(value))
    override val rules: Optional[List[zio.aws.ses.model.ReceiptRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ses.model.ReceiptRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DescribeActiveReceiptRuleSetResponse
  ): zio.aws.ses.model.DescribeActiveReceiptRuleSetResponse.ReadOnly =
    new Wrapper(impl)
}
