package zio.aws.ses.model
import zio.aws.ses.model.primitives.{ReceiptRuleName, ReceiptRuleSetName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeReceiptRuleRequest(
    ruleSetName: ReceiptRuleSetName,
    ruleName: ReceiptRuleName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DescribeReceiptRuleRequest = {
    import DescribeReceiptRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DescribeReceiptRuleRequest
      .builder()
      .ruleSetName(ReceiptRuleSetName.unwrap(ruleSetName): java.lang.String)
      .ruleName(ReceiptRuleName.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DescribeReceiptRuleRequest.ReadOnly =
    zio.aws.ses.model.DescribeReceiptRuleRequest.wrap(buildAwsValue())
}
object DescribeReceiptRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DescribeReceiptRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DescribeReceiptRuleRequest =
      zio.aws.ses.model.DescribeReceiptRuleRequest(ruleSetName, ruleName)
    def ruleSetName: ReceiptRuleSetName
    def ruleName: ReceiptRuleName
    def getRuleSetName: ZIO[Any, Nothing, ReceiptRuleSetName] =
      ZIO.succeed(ruleSetName)
    def getRuleName: ZIO[Any, Nothing, ReceiptRuleName] = ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DescribeReceiptRuleRequest
  ) extends zio.aws.ses.model.DescribeReceiptRuleRequest.ReadOnly {
    override val ruleSetName: ReceiptRuleSetName =
      zio.aws.ses.model.primitives.ReceiptRuleSetName(impl.ruleSetName())
    override val ruleName: ReceiptRuleName =
      zio.aws.ses.model.primitives.ReceiptRuleName(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DescribeReceiptRuleRequest
  ): zio.aws.ses.model.DescribeReceiptRuleRequest.ReadOnly = new Wrapper(impl)
}
