package zio.aws.ses.model
import scala.jdk.CollectionConverters._
sealed trait DimensionValueSource {
  def unwrap: software.amazon.awssdk.services.ses.model.DimensionValueSource
}
object DimensionValueSource {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.DimensionValueSource
  ): zio.aws.ses.model.DimensionValueSource = value match {
    case software.amazon.awssdk.services.ses.model.DimensionValueSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.DimensionValueSource.MESSAGE_TAG =>
      val r = messageTag
      r
    case software.amazon.awssdk.services.ses.model.DimensionValueSource.EMAIL_HEADER =>
      val r = emailHeader
      r
    case software.amazon.awssdk.services.ses.model.DimensionValueSource.LINK_TAG =>
      val r = linkTag
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ses.model.DimensionValueSource {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.DimensionValueSource =
      software.amazon.awssdk.services.ses.model.DimensionValueSource.UNKNOWN_TO_SDK_VERSION
  }
  case object messageTag extends zio.aws.ses.model.DimensionValueSource {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.DimensionValueSource =
      software.amazon.awssdk.services.ses.model.DimensionValueSource.MESSAGE_TAG
  }
  case object emailHeader extends zio.aws.ses.model.DimensionValueSource {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.DimensionValueSource =
      software.amazon.awssdk.services.ses.model.DimensionValueSource.EMAIL_HEADER
  }
  case object linkTag extends zio.aws.ses.model.DimensionValueSource {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.DimensionValueSource =
      software.amazon.awssdk.services.ses.model.DimensionValueSource.LINK_TAG
  }
}
