package zio.aws.ses.model
import scala.jdk.CollectionConverters._
sealed trait DsnAction {
  def unwrap: software.amazon.awssdk.services.ses.model.DsnAction
}
object DsnAction {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.DsnAction
  ): zio.aws.ses.model.DsnAction = value match {
    case software.amazon.awssdk.services.ses.model.DsnAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.DsnAction.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.ses.model.DsnAction.DELAYED =>
      val r = delayed
      r
    case software.amazon.awssdk.services.ses.model.DsnAction.DELIVERED =>
      val r = delivered
      r
    case software.amazon.awssdk.services.ses.model.DsnAction.RELAYED =>
      val r = relayed
      r
    case software.amazon.awssdk.services.ses.model.DsnAction.EXPANDED =>
      val r = expanded
      r
  }
  case object unknownToSdkVersion extends zio.aws.ses.model.DsnAction {
    override def unwrap: software.amazon.awssdk.services.ses.model.DsnAction =
      software.amazon.awssdk.services.ses.model.DsnAction.UNKNOWN_TO_SDK_VERSION
  }
  case object failed extends zio.aws.ses.model.DsnAction {
    override def unwrap: software.amazon.awssdk.services.ses.model.DsnAction =
      software.amazon.awssdk.services.ses.model.DsnAction.FAILED
  }
  case object delayed extends zio.aws.ses.model.DsnAction {
    override def unwrap: software.amazon.awssdk.services.ses.model.DsnAction =
      software.amazon.awssdk.services.ses.model.DsnAction.DELAYED
  }
  case object delivered extends zio.aws.ses.model.DsnAction {
    override def unwrap: software.amazon.awssdk.services.ses.model.DsnAction =
      software.amazon.awssdk.services.ses.model.DsnAction.DELIVERED
  }
  case object relayed extends zio.aws.ses.model.DsnAction {
    override def unwrap: software.amazon.awssdk.services.ses.model.DsnAction =
      software.amazon.awssdk.services.ses.model.DsnAction.RELAYED
  }
  case object expanded extends zio.aws.ses.model.DsnAction {
    override def unwrap: software.amazon.awssdk.services.ses.model.DsnAction =
      software.amazon.awssdk.services.ses.model.DsnAction.EXPANDED
  }
}
